/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterResult;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilterResult;

public class EventFilterResult
extends MonitoringFilterResult {
    public static final NodeId TypeId = Identifiers.EventFilterResult;
    public static final NodeId BinaryEncodingId = Identifiers.EventFilterResult_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.EventFilterResult_Encoding_DefaultXml;
    protected final StatusCode[] selectClauseResults;
    protected final DiagnosticInfo[] selectClauseDiagnosticInfos;
    protected final ContentFilterResult whereClauseResult;

    public EventFilterResult() {
        this.selectClauseResults = null;
        this.selectClauseDiagnosticInfos = null;
        this.whereClauseResult = null;
    }

    public EventFilterResult(StatusCode[] selectClauseResults, DiagnosticInfo[] selectClauseDiagnosticInfos, ContentFilterResult whereClauseResult) {
        this.selectClauseResults = selectClauseResults;
        this.selectClauseDiagnosticInfos = selectClauseDiagnosticInfos;
        this.whereClauseResult = whereClauseResult;
    }

    @Nullable
    public StatusCode[] getSelectClauseResults() {
        return this.selectClauseResults;
    }

    @Nullable
    public DiagnosticInfo[] getSelectClauseDiagnosticInfos() {
        return this.selectClauseDiagnosticInfos;
    }

    public ContentFilterResult getWhereClauseResult() {
        return this.whereClauseResult;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("SelectClauseResults", (Object)this.selectClauseResults).add("SelectClauseDiagnosticInfos", (Object)this.selectClauseDiagnosticInfos).add("WhereClauseResult", (Object)this.whereClauseResult).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<EventFilterResult> {
        @Override
        public Class<EventFilterResult> getType() {
            return EventFilterResult.class;
        }

        @Override
        public EventFilterResult decode(UaDecoder decoder) throws UaSerializationException {
            StatusCode[] selectClauseResults = decoder.readArray("SelectClauseResults", decoder::readStatusCode, StatusCode.class);
            DiagnosticInfo[] selectClauseDiagnosticInfos = decoder.readArray("SelectClauseDiagnosticInfos", decoder::readDiagnosticInfo, DiagnosticInfo.class);
            ContentFilterResult whereClauseResult = decoder.readBuiltinStruct("WhereClauseResult", ContentFilterResult.class);
            return new EventFilterResult(selectClauseResults, selectClauseDiagnosticInfos, whereClauseResult);
        }

        @Override
        public void encode(EventFilterResult value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeArray("SelectClauseResults", value.selectClauseResults, encoder::writeStatusCode);
            encoder.writeArray("SelectClauseDiagnosticInfos", value.selectClauseDiagnosticInfos, encoder::writeDiagnosticInfo);
            encoder.writeBuiltinStruct("WhereClauseResult", value.whereClauseResult, ContentFilterResult.class);
        }
    }
}

