/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class Argument
implements UaStructure {
    public static final NodeId TypeId = Identifiers.Argument;
    public static final NodeId BinaryEncodingId = Identifiers.Argument_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.Argument_Encoding_DefaultXml;
    protected final String name;
    protected final NodeId dataType;
    protected final Integer valueRank;
    protected final UInteger[] arrayDimensions;
    protected final LocalizedText description;

    public Argument() {
        this.name = null;
        this.dataType = null;
        this.valueRank = null;
        this.arrayDimensions = null;
        this.description = null;
    }

    public Argument(String name, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, LocalizedText description) {
        this.name = name;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.arrayDimensions = arrayDimensions;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public NodeId getDataType() {
        return this.dataType;
    }

    public Integer getValueRank() {
        return this.valueRank;
    }

    @Nullable
    public UInteger[] getArrayDimensions() {
        return this.arrayDimensions;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Name", (Object)this.name).add("DataType", (Object)this.dataType).add("ValueRank", (Object)this.valueRank).add("ArrayDimensions", (Object)this.arrayDimensions).add("Description", (Object)this.description).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<Argument> {
        @Override
        public Class<Argument> getType() {
            return Argument.class;
        }

        @Override
        public Argument decode(UaDecoder decoder) throws UaSerializationException {
            String name = decoder.readString("Name");
            NodeId dataType = decoder.readNodeId("DataType");
            Integer valueRank = decoder.readInt32("ValueRank");
            UInteger[] arrayDimensions = decoder.readArray("ArrayDimensions", decoder::readUInt32, UInteger.class);
            LocalizedText description = decoder.readLocalizedText("Description");
            return new Argument(name, dataType, valueRank, arrayDimensions, description);
        }

        @Override
        public void encode(Argument value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeString("Name", value.name);
            encoder.writeNodeId("DataType", value.dataType);
            encoder.writeInt32("ValueRank", value.valueRank);
            encoder.writeArray("ArrayDimensions", value.arrayDimensions, encoder::writeUInt32);
            encoder.writeLocalizedText("Description", value.description);
        }
    }
}

