/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum TimestampsToReturn implements UaEnumeration
{
    Source(0),
    Server(1),
    Both(2),
    Neither(3);

    private final int value;
    private static final ImmutableMap<Integer, TimestampsToReturn> VALUES;

    private TimestampsToReturn(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static TimestampsToReturn from(Integer value) {
        if (value == null) {
            return null;
        }
        return (TimestampsToReturn)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(TimestampsToReturn timestampsToReturn, UaEncoder encoder) {
        encoder.writeInt32(null, timestampsToReturn.getValue());
    }

    public static TimestampsToReturn decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (TimestampsToReturn)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TimestampsToReturn e : TimestampsToReturn.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

