/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization;

import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaXmlStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaXmlStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaXmlDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;

public interface SerializationContext {
    public EncodingLimits getEncodingLimits();

    public NamespaceTable getNamespaceTable();

    public DataTypeManager getDataTypeManager();

    default public Object decode(String namespaceUri, String description, OpcUaBinaryStreamDecoder decoder) throws UaSerializationException {
        DataTypeCodec codec = this.getDataTypeManager().getCodec(namespaceUri, description);
        if (codec instanceof OpcUaBinaryDataTypeCodec) {
            return codec.decode(this, decoder);
        }
        throw new UaSerializationException(0x80070000L, String.format("no OpcBinaryDataTypeCodec registered for description=%s under namespaceUri=%s", description, namespaceUri));
    }

    default public Object decode(String namespaceUri, String description, OpcUaXmlStreamDecoder decoder) throws UaSerializationException {
        DataTypeCodec codec = this.getDataTypeManager().getCodec(namespaceUri, description);
        if (codec instanceof OpcUaXmlDataTypeCodec) {
            return codec.decode(this, decoder);
        }
        throw new UaSerializationException(0x80070000L, String.format("no OpcXmlDataTypeCodec registered for description=%s under namespaceUri=%s", description, namespaceUri));
    }

    default public void encode(String namespaceUri, String description, Object value, OpcUaBinaryStreamEncoder encoder) throws UaSerializationException {
        DataTypeCodec codec = this.getDataTypeManager().getCodec(namespaceUri, description);
        if (!(codec instanceof OpcUaBinaryDataTypeCodec)) {
            throw new UaSerializationException(0x80060000L, String.format("no OpcBinaryDataTypeCodec registered for description=%s under namespaceUri=%s", description, namespaceUri));
        }
        codec.encode(this, encoder, value);
    }

    default public void encode(String namespaceUri, String description, Object value, OpcUaXmlStreamEncoder encoder) throws UaSerializationException {
        DataTypeCodec codec = this.getDataTypeManager().getCodec(namespaceUri, description);
        if (!(codec instanceof OpcUaXmlDataTypeCodec)) {
            throw new UaSerializationException(0x80060000L, String.format("no OpcXmlDataTypeCodec registered for description=%s under namespaceUri=%s", description, namespaceUri));
        }
        codec.encode(this, encoder, value);
    }
}

