/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core;

import java.util.Optional;
import org.eclipse.milo.opcua.stack.core.StatusCodes;
import org.eclipse.milo.opcua.stack.core.UaExceptionStatus;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class UaException
extends Exception
implements UaExceptionStatus {
    private final StatusCode statusCode;

    public UaException(long statusCode) {
        this.statusCode = new StatusCode(statusCode);
    }

    public UaException(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public UaException(Throwable cause) {
        super(cause);
        this.statusCode = new StatusCode(0x80020000L);
    }

    public UaException(long statusCode, Throwable cause) {
        super(cause);
        this.statusCode = new StatusCode(statusCode);
    }

    public UaException(long statusCode, String message) {
        super(message);
        this.statusCode = new StatusCode(statusCode);
    }

    public UaException(StatusCode statusCode, String message) {
        super(message);
        this.statusCode = statusCode;
    }

    @Override
    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null || message.isEmpty()) {
            Optional<String[]> lookup = StatusCodes.lookup(this.statusCode.getValue());
            String status = lookup.map(nd -> nd[0]).orElse(this.statusCode.toString());
            String description = lookup.map(nd -> nd[1]).orElse("");
            message = description.isEmpty() ? String.format("status=%s", status) : String.format("status=%s, description=%s", status, description);
        }
        return message;
    }

    @Override
    public String toString() {
        String clazzName = this.getClass().getSimpleName();
        Optional<String[]> lookup = StatusCodes.lookup(this.statusCode.getValue());
        String status = lookup.map(nd -> nd[0]).orElse(this.statusCode.toString());
        String message = super.getMessage();
        if (message == null) {
            message = lookup.map(nd -> nd[1]).orElse("");
        }
        if (message.isEmpty()) {
            return String.format("%s: status=%s", clazzName, status);
        }
        return String.format("%s: status=%s, message=%s", clazzName, status, message);
    }

    public static Optional<UaException> extract(Throwable ex) {
        if (ex instanceof UaException) {
            return Optional.of((UaException)ex);
        }
        Throwable cause = ex.getCause();
        return cause != null ? UaException.extract(cause) : Optional.empty();
    }

    public static Optional<StatusCode> extractStatusCode(Throwable ex) {
        return UaException.extract(ex).map(UaException::getStatusCode);
    }
}

