/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import java.util.function.Predicate;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpaceFilter;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;

public abstract class SimpleAddressSpaceFilter
implements AddressSpaceFilter {
    public static SimpleAddressSpaceFilter create(final Predicate<NodeId> filter) {
        return new SimpleAddressSpaceFilter(){

            @Override
            protected boolean filter(NodeId nodeId) {
                return filter.test(nodeId);
            }
        };
    }

    protected abstract boolean filter(NodeId var1);

    @Override
    public boolean filterBrowse(OpcUaServer server, NodeId nodeId) {
        return this.filter(nodeId);
    }

    @Override
    public boolean filterRegisterNode(OpcUaServer server, NodeId nodeId) {
        return this.filter(nodeId);
    }

    @Override
    public boolean filterUnregisterNode(OpcUaServer server, NodeId nodeId) {
        return this.filter(nodeId);
    }

    @Override
    public boolean filterRead(OpcUaServer server, ReadValueId readValueId) {
        return this.filter(readValueId.getNodeId());
    }

    @Override
    public boolean filterWrite(OpcUaServer server, WriteValue writeValue) {
        return this.filter(writeValue.getNodeId());
    }

    @Override
    public boolean filterHistoryRead(OpcUaServer server, HistoryReadValueId historyReadValueId) {
        return this.filter(historyReadValueId.getNodeId());
    }

    @Override
    public boolean filterHistoryUpdate(OpcUaServer server, HistoryUpdateDetails historyUpdateDetails) {
        return this.filter(historyUpdateDetails.getNodeId());
    }

    @Override
    public boolean filterCall(OpcUaServer server, CallMethodRequest callMethodRequest) {
        return this.filter(callMethodRequest.getObjectId());
    }

    @Override
    public boolean filterOnCreateDataItem(OpcUaServer server, ReadValueId readValueId) {
        return this.filter(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnModifyDataItem(OpcUaServer server, ReadValueId readValueId) {
        return this.filter(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnCreateEventItem(OpcUaServer server, ReadValueId readValueId) {
        return this.filter(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnModifyEventItem(OpcUaServer server, ReadValueId readValueId) {
        return this.filter(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnDataItemsCreated(OpcUaServer server, ReadValueId readValueId) {
        return this.filter(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnDataItemsModified(OpcUaServer server, ReadValueId readValueId) {
        return this.filter(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnDataItemsDeleted(OpcUaServer server, ReadValueId readValueId) {
        return this.filter(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnEventItemsCreated(OpcUaServer server, ReadValueId readValueId) {
        return this.filter(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnEventItemsModified(OpcUaServer server, ReadValueId readValueId) {
        return this.filter(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnEventItemsDeleted(OpcUaServer server, ReadValueId readValueId) {
        return this.filter(readValueId.getNodeId());
    }

    @Override
    public boolean filterOnMonitoringModeChanged(OpcUaServer server, ReadValueId readValueId) {
        return this.filter(readValueId.getNodeId());
    }

    @Override
    public boolean filterAddNodes(OpcUaServer server, AddNodesItem addNodesItem) {
        NamespaceTable namespaceTable = server.getNamespaceTable();
        ExpandedNodeId requestedNewNodeId = addNodesItem.getRequestedNewNodeId();
        if (requestedNewNodeId.isNotNull()) {
            return requestedNewNodeId.local(namespaceTable).map(this::filter).orElse(false);
        }
        return addNodesItem.getParentNodeId().local(namespaceTable).map(this::filter).orElse(false);
    }

    @Override
    public boolean filterDeleteNodes(OpcUaServer server, DeleteNodesItem deleteNodesItem) {
        return this.filter(deleteNodesItem.getNodeId());
    }

    @Override
    public boolean filterAddReferences(OpcUaServer server, AddReferencesItem addReferencesItem) {
        return this.filter(addReferencesItem.getSourceNodeId());
    }

    @Override
    public boolean filterDeleteReferences(OpcUaServer server, DeleteReferencesItem deleteReferencesItem) {
        return this.filter(deleteReferencesItem.getSourceNodeId());
    }
}

