/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.binaryschema.parser;

import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.eclipse.milo.opcua.binaryschema.parser.CodecDescription;
import org.eclipse.milo.opcua.binaryschema.parser.DictionaryDescription;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.opcfoundation.opcua.binaryschema.EnumeratedType;
import org.opcfoundation.opcua.binaryschema.ObjectFactory;
import org.opcfoundation.opcua.binaryschema.StructuredType;
import org.opcfoundation.opcua.binaryschema.TypeDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BsdParser {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DictionaryDescription parse(InputStream inputStream) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        TypeDictionary typeDictionary = (TypeDictionary)context.createUnmarshaller().unmarshal(inputStream);
        List<CodecDescription> enumCodecs = typeDictionary.getOpaqueTypeOrEnumeratedTypeOrStructuredType().stream().filter(typeDescription -> typeDescription instanceof EnumeratedType).map(typeDescription -> {
            EnumeratedType enumeratedType = (EnumeratedType)typeDescription;
            this.logger.debug("EnumeratedType: {}", (Object)typeDescription.getName());
            return new CodecDescription(this.getEnumCodec(enumeratedType), enumeratedType.getName());
        }).collect(Collectors.toList());
        List<CodecDescription> structCodecs = typeDictionary.getOpaqueTypeOrEnumeratedTypeOrStructuredType().stream().filter(typeDescription -> typeDescription instanceof StructuredType).map(typeDescription -> {
            StructuredType structuredType = (StructuredType)typeDescription;
            this.logger.debug("StructuredType: {}", (Object)typeDescription.getName());
            return new CodecDescription(this.getStructCodec(structuredType), structuredType.getName());
        }).collect(Collectors.toList());
        return new DictionaryDescription(typeDictionary.getTargetNamespace(), enumCodecs, structCodecs);
    }

    protected abstract OpcUaBinaryDataTypeCodec<?> getEnumCodec(EnumeratedType var1);

    protected abstract OpcUaBinaryDataTypeCodec<?> getStructCodec(StructuredType var1);
}

