/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;

public class EndpointUtil {
    private static final Pattern ENDPOINT_URL_PATTERN = Pattern.compile("(opc.tcp|http|https|opc.http|opc.https|opc.ws|opc.wss)://([^:/]+|\\[.*])(:\\d+)?(/.*)?");

    @Nullable
    public static String getScheme(@Nonnull String endpointUrl) {
        Matcher matcher = ENDPOINT_URL_PATTERN.matcher(endpointUrl);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    @Nullable
    public static String getHost(@Nonnull String endpointUrl) {
        Matcher matcher = ENDPOINT_URL_PATTERN.matcher(endpointUrl);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    public static int getPort(@Nonnull String endpointUrl) {
        Matcher matcher = ENDPOINT_URL_PATTERN.matcher(endpointUrl);
        if (matcher.matches()) {
            try {
                String group = matcher.group(3);
                if (group != null && group.startsWith(":")) {
                    group = group.substring(1);
                    return Integer.valueOf(group);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 4840;
    }

    @Nonnull
    public static String getPath(@Nonnull String endpointUrl) {
        Matcher matcher = ENDPOINT_URL_PATTERN.matcher(endpointUrl);
        if (matcher.matches()) {
            String path = matcher.group(4);
            if (path == null || path.isEmpty()) {
                path = "/";
            } else if (path.length() > 1 && path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            return path;
        }
        return "/";
    }

    public static EndpointDescription updateUrl(@Nonnull EndpointDescription endpoint, @Nullable String hostname) {
        return EndpointUtil.updateUrl(endpoint, hostname, -1);
    }

    public static EndpointDescription updateUrl(@Nonnull EndpointDescription endpoint, @Nullable String hostname, int port) {
        return new EndpointDescription(EndpointUtil.updateUrl(endpoint.getEndpointUrl(), hostname, port), endpoint.getServer(), endpoint.getServerCertificate(), endpoint.getSecurityMode(), endpoint.getSecurityPolicyUri(), endpoint.getUserIdentityTokens(), endpoint.getTransportProfileUri(), endpoint.getSecurityLevel());
    }

    static String updateUrl(String endpointUrl, @Nullable String hostname) {
        return EndpointUtil.updateUrl(endpointUrl, hostname, -1);
    }

    static String updateUrl(String endpointUrl, @Nullable String hostname, int port) {
        Matcher matcher = ENDPOINT_URL_PATTERN.matcher(endpointUrl);
        if (matcher.matches()) {
            String scheme = matcher.group(1);
            String newHostname = matcher.group(2);
            if (hostname != null) {
                newHostname = hostname;
            }
            String newPort = matcher.group(3);
            if (port >= 0) {
                newPort = ":" + port;
            } else if (newPort == null) {
                newPort = "";
            }
            String path = matcher.group(4);
            if (path == null) {
                path = "";
            }
            return scheme + "://" + newHostname + newPort + path;
        }
        return endpointUrl;
    }
}

