/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class ServerDiagnosticsSummaryDataType
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ServerDiagnosticsSummaryDataType;
    public static final NodeId BinaryEncodingId = Identifiers.ServerDiagnosticsSummaryDataType_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ServerDiagnosticsSummaryDataType_Encoding_DefaultXml;
    protected final UInteger serverViewCount;
    protected final UInteger currentSessionCount;
    protected final UInteger cumulatedSessionCount;
    protected final UInteger securityRejectedSessionCount;
    protected final UInteger rejectedSessionCount;
    protected final UInteger sessionTimeoutCount;
    protected final UInteger sessionAbortCount;
    protected final UInteger currentSubscriptionCount;
    protected final UInteger cumulatedSubscriptionCount;
    protected final UInteger publishingIntervalCount;
    protected final UInteger securityRejectedRequestsCount;
    protected final UInteger rejectedRequestsCount;

    public ServerDiagnosticsSummaryDataType() {
        this.serverViewCount = null;
        this.currentSessionCount = null;
        this.cumulatedSessionCount = null;
        this.securityRejectedSessionCount = null;
        this.rejectedSessionCount = null;
        this.sessionTimeoutCount = null;
        this.sessionAbortCount = null;
        this.currentSubscriptionCount = null;
        this.cumulatedSubscriptionCount = null;
        this.publishingIntervalCount = null;
        this.securityRejectedRequestsCount = null;
        this.rejectedRequestsCount = null;
    }

    public ServerDiagnosticsSummaryDataType(UInteger serverViewCount, UInteger currentSessionCount, UInteger cumulatedSessionCount, UInteger securityRejectedSessionCount, UInteger rejectedSessionCount, UInteger sessionTimeoutCount, UInteger sessionAbortCount, UInteger currentSubscriptionCount, UInteger cumulatedSubscriptionCount, UInteger publishingIntervalCount, UInteger securityRejectedRequestsCount, UInteger rejectedRequestsCount) {
        this.serverViewCount = serverViewCount;
        this.currentSessionCount = currentSessionCount;
        this.cumulatedSessionCount = cumulatedSessionCount;
        this.securityRejectedSessionCount = securityRejectedSessionCount;
        this.rejectedSessionCount = rejectedSessionCount;
        this.sessionTimeoutCount = sessionTimeoutCount;
        this.sessionAbortCount = sessionAbortCount;
        this.currentSubscriptionCount = currentSubscriptionCount;
        this.cumulatedSubscriptionCount = cumulatedSubscriptionCount;
        this.publishingIntervalCount = publishingIntervalCount;
        this.securityRejectedRequestsCount = securityRejectedRequestsCount;
        this.rejectedRequestsCount = rejectedRequestsCount;
    }

    public UInteger getServerViewCount() {
        return this.serverViewCount;
    }

    public UInteger getCurrentSessionCount() {
        return this.currentSessionCount;
    }

    public UInteger getCumulatedSessionCount() {
        return this.cumulatedSessionCount;
    }

    public UInteger getSecurityRejectedSessionCount() {
        return this.securityRejectedSessionCount;
    }

    public UInteger getRejectedSessionCount() {
        return this.rejectedSessionCount;
    }

    public UInteger getSessionTimeoutCount() {
        return this.sessionTimeoutCount;
    }

    public UInteger getSessionAbortCount() {
        return this.sessionAbortCount;
    }

    public UInteger getCurrentSubscriptionCount() {
        return this.currentSubscriptionCount;
    }

    public UInteger getCumulatedSubscriptionCount() {
        return this.cumulatedSubscriptionCount;
    }

    public UInteger getPublishingIntervalCount() {
        return this.publishingIntervalCount;
    }

    public UInteger getSecurityRejectedRequestsCount() {
        return this.securityRejectedRequestsCount;
    }

    public UInteger getRejectedRequestsCount() {
        return this.rejectedRequestsCount;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ServerViewCount", (Object)this.serverViewCount).add("CurrentSessionCount", (Object)this.currentSessionCount).add("CumulatedSessionCount", (Object)this.cumulatedSessionCount).add("SecurityRejectedSessionCount", (Object)this.securityRejectedSessionCount).add("RejectedSessionCount", (Object)this.rejectedSessionCount).add("SessionTimeoutCount", (Object)this.sessionTimeoutCount).add("SessionAbortCount", (Object)this.sessionAbortCount).add("CurrentSubscriptionCount", (Object)this.currentSubscriptionCount).add("CumulatedSubscriptionCount", (Object)this.cumulatedSubscriptionCount).add("PublishingIntervalCount", (Object)this.publishingIntervalCount).add("SecurityRejectedRequestsCount", (Object)this.securityRejectedRequestsCount).add("RejectedRequestsCount", (Object)this.rejectedRequestsCount).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ServerDiagnosticsSummaryDataType> {
        @Override
        public Class<ServerDiagnosticsSummaryDataType> getType() {
            return ServerDiagnosticsSummaryDataType.class;
        }

        @Override
        public ServerDiagnosticsSummaryDataType decode(UaDecoder decoder) throws UaSerializationException {
            UInteger serverViewCount = decoder.readUInt32("ServerViewCount");
            UInteger currentSessionCount = decoder.readUInt32("CurrentSessionCount");
            UInteger cumulatedSessionCount = decoder.readUInt32("CumulatedSessionCount");
            UInteger securityRejectedSessionCount = decoder.readUInt32("SecurityRejectedSessionCount");
            UInteger rejectedSessionCount = decoder.readUInt32("RejectedSessionCount");
            UInteger sessionTimeoutCount = decoder.readUInt32("SessionTimeoutCount");
            UInteger sessionAbortCount = decoder.readUInt32("SessionAbortCount");
            UInteger currentSubscriptionCount = decoder.readUInt32("CurrentSubscriptionCount");
            UInteger cumulatedSubscriptionCount = decoder.readUInt32("CumulatedSubscriptionCount");
            UInteger publishingIntervalCount = decoder.readUInt32("PublishingIntervalCount");
            UInteger securityRejectedRequestsCount = decoder.readUInt32("SecurityRejectedRequestsCount");
            UInteger rejectedRequestsCount = decoder.readUInt32("RejectedRequestsCount");
            return new ServerDiagnosticsSummaryDataType(serverViewCount, currentSessionCount, cumulatedSessionCount, securityRejectedSessionCount, rejectedSessionCount, sessionTimeoutCount, sessionAbortCount, currentSubscriptionCount, cumulatedSubscriptionCount, publishingIntervalCount, securityRejectedRequestsCount, rejectedRequestsCount);
        }

        @Override
        public void encode(ServerDiagnosticsSummaryDataType value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeUInt32("ServerViewCount", value.serverViewCount);
            encoder.writeUInt32("CurrentSessionCount", value.currentSessionCount);
            encoder.writeUInt32("CumulatedSessionCount", value.cumulatedSessionCount);
            encoder.writeUInt32("SecurityRejectedSessionCount", value.securityRejectedSessionCount);
            encoder.writeUInt32("RejectedSessionCount", value.rejectedSessionCount);
            encoder.writeUInt32("SessionTimeoutCount", value.sessionTimeoutCount);
            encoder.writeUInt32("SessionAbortCount", value.sessionAbortCount);
            encoder.writeUInt32("CurrentSubscriptionCount", value.currentSubscriptionCount);
            encoder.writeUInt32("CumulatedSubscriptionCount", value.cumulatedSubscriptionCount);
            encoder.writeUInt32("PublishingIntervalCount", value.publishingIntervalCount);
            encoder.writeUInt32("SecurityRejectedRequestsCount", value.securityRejectedRequestsCount);
            encoder.writeUInt32("RejectedRequestsCount", value.rejectedRequestsCount);
        }
    }
}

