/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.serialization;

import io.netty.buffer.ByteBuf;
import io.netty.util.ByteProcessor;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaBinaryDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.BuiltinDataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultBinaryEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.XmlElement;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.util.ArrayUtil;
import org.eclipse.milo.opcua.stack.core.util.TypeUtil;

public class OpcUaBinaryStreamDecoder
implements UaDecoder {
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private static final Charset CHARSET_UTF16 = Charset.forName("UTF-16");
    private volatile ByteBuf buffer;
    private volatile int currentByte = 0;
    private volatile int bitsRemaining = 0;
    private final AtomicInteger depth = new AtomicInteger(0);
    private final SerializationContext context;

    public OpcUaBinaryStreamDecoder(SerializationContext context) {
        this.context = context;
    }

    public OpcUaBinaryStreamDecoder setBuffer(ByteBuf buffer) {
        this.buffer = buffer;
        return this;
    }

    public <T> T[] readArray(Supplier<T> read, Class<T> clazz) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        Object[] array = (Object[])Array.newInstance(clazz, length);
        for (int i = 0; i < length; ++i) {
            array[i] = read.get();
        }
        return array;
    }

    public int readBit() throws UaSerializationException {
        if (this.bitsRemaining == 0) {
            this.currentByte = this.buffer.readUnsignedByte();
            this.bitsRemaining = 8;
        }
        int bit = this.currentByte & 1;
        this.currentByte >>= 1;
        --this.bitsRemaining;
        return bit;
    }

    public Character readCharacter() throws UaSerializationException {
        return Character.valueOf((char)this.buffer.readUnsignedByte());
    }

    public Character readWideChar() throws UaSerializationException {
        return Character.valueOf(this.buffer.readChar());
    }

    public String readUtf8NullTerminatedString() throws UaSerializationException {
        return this.readNullTerminatedString(CHARSET_UTF8);
    }

    public String readUtf8CharArray() throws UaSerializationException {
        return this.readLengthPrefixedString(CHARSET_UTF8);
    }

    public String readUtf16NullTerminatedString() throws UaSerializationException {
        return this.readNullTerminatedString(CHARSET_UTF16);
    }

    public String readUtf16CharArray() throws UaSerializationException {
        return this.readLengthPrefixedString(CHARSET_UTF16);
    }

    public Boolean readBoolean() throws UaSerializationException {
        return this.buffer.readBoolean();
    }

    public Byte readSByte() throws UaSerializationException {
        return this.buffer.readByte();
    }

    public UByte readByte() throws UaSerializationException {
        return Unsigned.ubyte(this.buffer.readUnsignedByte());
    }

    public Short readInt16() throws UaSerializationException {
        return this.buffer.readShortLE();
    }

    public UShort readUInt16() throws UaSerializationException {
        return Unsigned.ushort(this.buffer.readUnsignedShortLE());
    }

    public Integer readInt32() throws UaSerializationException {
        return this.buffer.readIntLE();
    }

    public UInteger readUInt32() throws UaSerializationException {
        return Unsigned.uint(this.buffer.readUnsignedIntLE());
    }

    public Long readInt64() throws UaSerializationException {
        return this.buffer.readLongLE();
    }

    public ULong readUInt64() throws UaSerializationException {
        return Unsigned.ulong(this.buffer.readLongLE());
    }

    public Float readFloat() throws UaSerializationException {
        return Float.valueOf(this.buffer.readFloatLE());
    }

    public Double readDouble() throws UaSerializationException {
        return this.buffer.readDoubleLE();
    }

    public DateTime readDateTime() throws UaSerializationException {
        return new DateTime(this.buffer.readLongLE());
    }

    public ByteString readByteString() throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return ByteString.NULL_VALUE;
        }
        this.checkArrayLength(length);
        byte[] bs = new byte[length];
        this.buffer.readBytes(bs);
        return new ByteString(bs);
    }

    public UUID readGuid() throws UaSerializationException {
        long part1 = this.buffer.readUnsignedIntLE();
        long part2 = this.buffer.readUnsignedShortLE();
        long part3 = this.buffer.readUnsignedShortLE();
        long part4 = this.buffer.readLong();
        long msb = part1 << 32 | part2 << 16 | part3;
        return new UUID(msb, part4);
    }

    public XmlElement readXmlElement() throws UaSerializationException {
        ByteString byteString = this.readByteString();
        byte[] bs = byteString.bytes();
        if (bs == null) {
            return new XmlElement(null);
        }
        String fragment = new String(bs, StandardCharsets.UTF_8);
        return new XmlElement(fragment);
    }

    public DataValue readDataValue() throws UaSerializationException {
        int mask = this.buffer.readByte() & 0xFF;
        Variant value = (mask & 1) != 0 ? this.readVariant() : Variant.NULL_VALUE;
        StatusCode status = (mask & 2) != 0 ? this.readStatusCode() : StatusCode.GOOD;
        DateTime sourceTime = (mask & 4) != 0 ? this.readDateTime() : DateTime.MIN_VALUE;
        UShort sourcePicoseconds = (mask & 0x10) != 0 ? this.readUInt16() : null;
        DateTime serverTime = (mask & 8) != 0 ? this.readDateTime() : DateTime.MIN_VALUE;
        UShort serverPicoseconds = (mask & 0x20) != 0 ? this.readUInt16() : null;
        return new DataValue(value, status, sourceTime, sourcePicoseconds, serverTime, serverPicoseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagnosticInfo readDiagnosticInfo() throws UaSerializationException {
        if (this.depth.get() >= this.context.getEncodingLimits().getMaxRecursionDepth()) {
            throw new UaSerializationException(0x80080000L, "max recursion depth exceeded: " + this.context.getEncodingLimits().getMaxRecursionDepth());
        }
        this.depth.incrementAndGet();
        try {
            byte mask = this.buffer.readByte();
            if (mask == 0) {
                DiagnosticInfo diagnosticInfo = null;
                return diagnosticInfo;
            }
            int symbolicId = (mask & 1) == 1 ? this.readInt32() : -1;
            int namespaceUri = (mask & 2) == 2 ? this.readInt32() : -1;
            int localizedText = (mask & 4) == 4 ? this.readInt32() : -1;
            int locale = (mask & 8) == 8 ? this.readInt32() : -1;
            String additionalInfo = (mask & 0x10) == 16 ? this.readString() : null;
            StatusCode innerStatusCode = (mask & 0x20) == 32 ? this.readStatusCode() : null;
            DiagnosticInfo innerDiagnosticInfo = (mask & 0x40) == 64 ? this.readDiagnosticInfo() : null;
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(namespaceUri, symbolicId, locale, localizedText, additionalInfo, innerStatusCode, innerDiagnosticInfo);
            return diagnosticInfo;
        }
        finally {
            this.depth.decrementAndGet();
        }
    }

    public ExpandedNodeId readExpandedNodeId() throws UaSerializationException {
        byte flags = this.buffer.getByte(this.buffer.readerIndex());
        NodeId nodeId = this.readNodeId();
        String namespaceUri = null;
        long serverIndex = 0L;
        if ((flags & 0x80) == 128) {
            namespaceUri = this.readString();
        }
        if ((flags & 0x40) == 64) {
            serverIndex = this.readUInt32().longValue();
        }
        return new ExpandedNodeId(nodeId, namespaceUri, serverIndex);
    }

    public ExtensionObject readExtensionObject() throws UaSerializationException {
        NodeId encodingTypeId = this.readNodeId();
        byte encoding = this.buffer.readByte();
        if (encoding == 0) {
            return new ExtensionObject(ByteString.NULL_VALUE, encodingTypeId);
        }
        if (encoding == 1) {
            ByteString byteString = this.readByteString();
            return new ExtensionObject(byteString, encodingTypeId);
        }
        if (encoding == 2) {
            XmlElement xmlElement = this.readXmlElement();
            return new ExtensionObject(xmlElement, encodingTypeId);
        }
        throw new UaSerializationException(0x80070000L, "unknown ExtensionObject encoding: " + encoding);
    }

    public LocalizedText readLocalizedText() throws UaSerializationException {
        byte mask = this.buffer.readByte();
        String locale = null;
        String text = null;
        if ((mask & 1) == 1) {
            locale = this.readString();
        }
        if ((mask & 2) == 2) {
            text = this.readString();
        }
        return new LocalizedText(locale, text);
    }

    public NodeId readNodeId() throws UaSerializationException {
        int format = this.buffer.readByte() & 0xF;
        if (format == 0) {
            return new NodeId(UShort.MIN, Unsigned.uint(this.buffer.readUnsignedByte()));
        }
        if (format == 1) {
            return new NodeId(Unsigned.ushort(this.buffer.readUnsignedByte()), Unsigned.uint(this.buffer.readUnsignedShortLE()));
        }
        if (format == 2) {
            return new NodeId(this.readUInt16(), this.readUInt32());
        }
        if (format == 3) {
            return new NodeId(this.readUInt16(), this.readString());
        }
        if (format == 4) {
            return new NodeId(this.readUInt16(), this.readGuid());
        }
        if (format == 5) {
            return new NodeId(this.readUInt16(), this.readByteString());
        }
        throw new UaSerializationException(0x80070000L, "invalid NodeId format: " + format);
    }

    public QualifiedName readQualifiedName() throws UaSerializationException {
        UShort namespaceIndex = this.readUInt16();
        String name = this.readString();
        return new QualifiedName(namespaceIndex, name);
    }

    public StatusCode readStatusCode() throws UaSerializationException {
        return new StatusCode(this.readUInt32());
    }

    public String readString() throws UaSerializationException {
        return this.readLengthPrefixedString(CHARSET_UTF8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variant readVariant() throws UaSerializationException {
        if (this.depth.get() >= this.context.getEncodingLimits().getMaxRecursionDepth()) {
            throw new UaSerializationException(0x80080000L, "max recursion depth exceeded: " + this.context.getEncodingLimits().getMaxRecursionDepth());
        }
        this.depth.incrementAndGet();
        try {
            boolean arrayEncoded;
            byte encodingMask = this.buffer.readByte();
            if (encodingMask == 0) {
                Variant variant = new Variant(null);
                return variant;
            }
            int typeId = encodingMask & 0x3F;
            boolean dimensionsEncoded = (encodingMask & 0x40) == 64;
            boolean bl = arrayEncoded = (encodingMask & 0x80) == 128;
            if (arrayEncoded) {
                int[] nArray;
                Class<?> backingClass = TypeUtil.getBackingClass(typeId);
                int length = this.readInt32();
                if (length == -1) {
                    Variant variant = new Variant(null);
                    return variant;
                }
                this.checkArrayLength(length);
                Object flatArray = Array.newInstance(backingClass, length);
                for (int i = 0; i < length; ++i) {
                    Object element = this.decodeBuiltinType(typeId);
                    Array.set(flatArray, i, element);
                }
                if (dimensionsEncoded) {
                    nArray = this.decodeDimensions();
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = length;
                }
                int[] dimensions = nArray;
                Object array = dimensions.length > 1 ? ArrayUtil.unflatten(flatArray, dimensions) : flatArray;
                Variant variant = new Variant(array);
                return variant;
            }
            Object value = this.decodeBuiltinType(typeId);
            Variant variant = new Variant(value);
            return variant;
        }
        finally {
            this.depth.decrementAndGet();
        }
    }

    @Nullable
    private String readLengthPrefixedString(Charset charset) {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        if (length > this.context.getEncodingLimits().getMaxStringLength()) {
            throw new UaSerializationException(0x80080000L, String.format("max string length exceeded (length=%s, max=%s)", length, this.context.getEncodingLimits().getMaxStringLength()));
        }
        String str = this.buffer.toString(this.buffer.readerIndex(), length, charset);
        this.buffer.skipBytes(length);
        return str;
    }

    private String readNullTerminatedString(Charset charset) {
        int indexOfNull = this.buffer.forEachByte(ByteProcessor.FIND_NUL);
        if (indexOfNull == -1) {
            throw new UaSerializationException(0x80070000L, "null terminator not found");
        }
        int index = this.buffer.readerIndex();
        int length = indexOfNull - index;
        String str = this.buffer.toString(index, length, charset);
        this.buffer.skipBytes(length + 1);
        return str;
    }

    private int[] decodeDimensions() {
        int length = this.readInt32();
        if (length == -1) {
            return new int[0];
        }
        int[] is = new int[length];
        for (int i = 0; i < length; ++i) {
            is[i] = this.readInt32();
        }
        return is;
    }

    private Object decodeBuiltinType(int typeId) throws UaSerializationException {
        switch (typeId) {
            case 1: {
                return this.readBoolean();
            }
            case 2: {
                return this.readSByte();
            }
            case 3: {
                return this.readByte();
            }
            case 4: {
                return this.readInt16();
            }
            case 5: {
                return this.readUInt16();
            }
            case 6: {
                return this.readInt32();
            }
            case 7: {
                return this.readUInt32();
            }
            case 8: {
                return this.readInt64();
            }
            case 9: {
                return this.readUInt64();
            }
            case 10: {
                return this.readFloat();
            }
            case 11: {
                return this.readDouble();
            }
            case 12: {
                return this.readString();
            }
            case 13: {
                return this.readDateTime();
            }
            case 14: {
                return this.readGuid();
            }
            case 15: {
                return this.readByteString();
            }
            case 16: {
                return this.readXmlElement();
            }
            case 17: {
                return this.readNodeId();
            }
            case 18: {
                return this.readExpandedNodeId();
            }
            case 19: {
                return this.readStatusCode();
            }
            case 20: {
                return this.readQualifiedName();
            }
            case 21: {
                return this.readLocalizedText();
            }
            case 22: {
                return this.readExtensionObject();
            }
            case 23: {
                return this.readDataValue();
            }
            case 24: {
                return this.readVariant();
            }
            case 25: {
                return this.readDiagnosticInfo();
            }
        }
        throw new UaSerializationException(0x80070000L, "unknown builtin type: " + typeId);
    }

    @Override
    public Boolean readBoolean(String field) throws UaSerializationException {
        return this.readBoolean();
    }

    @Override
    public Byte readSByte(String field) throws UaSerializationException {
        return this.readSByte();
    }

    @Override
    public Short readInt16(String field) throws UaSerializationException {
        return this.readInt16();
    }

    @Override
    public Integer readInt32(String field) throws UaSerializationException {
        return this.readInt32();
    }

    @Override
    public Long readInt64(String field) throws UaSerializationException {
        return this.readInt64();
    }

    @Override
    public UByte readByte(String field) throws UaSerializationException {
        return this.readByte();
    }

    @Override
    public UShort readUInt16(String field) throws UaSerializationException {
        return this.readUInt16();
    }

    @Override
    public UInteger readUInt32(String field) throws UaSerializationException {
        return this.readUInt32();
    }

    @Override
    public ULong readUInt64(String field) throws UaSerializationException {
        return this.readUInt64();
    }

    @Override
    public Float readFloat(String field) throws UaSerializationException {
        return this.readFloat();
    }

    @Override
    public Double readDouble(String field) throws UaSerializationException {
        return this.readDouble();
    }

    @Override
    public String readString(String field) throws UaSerializationException {
        return this.readString();
    }

    @Override
    public DateTime readDateTime(String field) throws UaSerializationException {
        return this.readDateTime();
    }

    @Override
    public UUID readGuid(String field) throws UaSerializationException {
        return this.readGuid();
    }

    @Override
    public ByteString readByteString(String field) throws UaSerializationException {
        return this.readByteString();
    }

    @Override
    public XmlElement readXmlElement(String field) throws UaSerializationException {
        return this.readXmlElement();
    }

    @Override
    public NodeId readNodeId(String field) throws UaSerializationException {
        return this.readNodeId();
    }

    @Override
    public ExpandedNodeId readExpandedNodeId(String field) throws UaSerializationException {
        return this.readExpandedNodeId();
    }

    @Override
    public StatusCode readStatusCode(String field) throws UaSerializationException {
        return this.readStatusCode();
    }

    @Override
    public QualifiedName readQualifiedName(String field) throws UaSerializationException {
        return this.readQualifiedName();
    }

    @Override
    public LocalizedText readLocalizedText(String field) throws UaSerializationException {
        return this.readLocalizedText();
    }

    @Override
    public ExtensionObject readExtensionObject(String field) throws UaSerializationException {
        return this.readExtensionObject();
    }

    @Override
    public DataValue readDataValue(String field) throws UaSerializationException {
        return this.readDataValue();
    }

    @Override
    public Variant readVariant(String field) throws UaSerializationException {
        return this.readVariant();
    }

    @Override
    public DiagnosticInfo readDiagnosticInfo(String field) throws UaSerializationException {
        return this.readDiagnosticInfo();
    }

    @Override
    public UaMessage readMessage(String field) throws UaSerializationException {
        NodeId encodingId = this.readNodeId();
        OpcUaBinaryDataTypeCodec binaryCodec = (OpcUaBinaryDataTypeCodec)OpcUaDataTypeManager.getInstance().getCodec(encodingId);
        if (binaryCodec != null) {
            return (UaMessage)binaryCodec.decode(this.context, this);
        }
        throw new UaSerializationException(0x80070000L, "no codec registered: " + encodingId);
    }

    @Override
    public Object readStruct(String field, NodeId dataTypeId) throws UaSerializationException {
        OpcUaBinaryDataTypeCodec binaryCodec = (OpcUaBinaryDataTypeCodec)OpcUaDataTypeManager.getInstance().getCodec(OpcUaDefaultBinaryEncoding.ENCODING_NAME, dataTypeId);
        if (binaryCodec != null) {
            return binaryCodec.decode(this.context, this);
        }
        throw new UaSerializationException(0x80070000L, "no codec registered: " + dataTypeId);
    }

    @Override
    public Object readStruct(String field, ExpandedNodeId dataTypeId) throws UaSerializationException {
        return dataTypeId.local(this.context.getNamespaceTable()).map(id -> this.readStruct(field, (NodeId)id)).orElseThrow(() -> new UaSerializationException(0x80070000L, "no codec registered: " + dataTypeId));
    }

    @Override
    public Object readStruct(String field, DataTypeCodec codec) throws UaSerializationException {
        if (codec instanceof OpcUaBinaryDataTypeCodec) {
            OpcUaBinaryDataTypeCodec binaryCodec = (OpcUaBinaryDataTypeCodec)codec;
            return binaryCodec.decode(this.context, this);
        }
        throw new UaSerializationException(0x80070000L, (Throwable)new IllegalArgumentException("codec: " + codec));
    }

    @Override
    public Boolean[] readBooleanArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        Boolean[] values = new Boolean[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readBoolean(field);
        }
        return values;
    }

    @Override
    public Byte[] readSByteArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        Byte[] values = new Byte[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readSByte(field);
        }
        return values;
    }

    @Override
    public Short[] readInt16Array(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        Short[] values = new Short[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readInt16(field);
        }
        return values;
    }

    @Override
    public Integer[] readInt32Array(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        Integer[] values = new Integer[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readInt32(field);
        }
        return values;
    }

    @Override
    public Long[] readInt64Array(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        Long[] values = new Long[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readInt64(field);
        }
        return values;
    }

    @Override
    public UByte[] readByteArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        UByte[] values = new UByte[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readByte(field);
        }
        return values;
    }

    @Override
    public UShort[] readUInt16Array(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        UShort[] values = new UShort[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readUInt16(field);
        }
        return values;
    }

    @Override
    public UInteger[] readUInt32Array(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        UInteger[] values = new UInteger[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readUInt32(field);
        }
        return values;
    }

    @Override
    public ULong[] readUInt64Array(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        ULong[] values = new ULong[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readUInt64(field);
        }
        return values;
    }

    @Override
    public Float[] readFloatArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        Float[] values = new Float[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readFloat(field);
        }
        return values;
    }

    @Override
    public Double[] readDoubleArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        Double[] values = new Double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readDouble(field);
        }
        return values;
    }

    @Override
    public String[] readStringArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        String[] values = new String[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readString(field);
        }
        return values;
    }

    @Override
    public DateTime[] readDateTimeArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        DateTime[] values = new DateTime[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readDateTime(field);
        }
        return values;
    }

    @Override
    public UUID[] readGuidArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        UUID[] values = new UUID[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readGuid(field);
        }
        return values;
    }

    @Override
    public ByteString[] readByteStringArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        ByteString[] values = new ByteString[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readByteString(field);
        }
        return values;
    }

    @Override
    public XmlElement[] readXmlElementArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        XmlElement[] values = new XmlElement[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readXmlElement(field);
        }
        return values;
    }

    @Override
    public NodeId[] readNodeIdArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        NodeId[] values = new NodeId[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readNodeId(field);
        }
        return values;
    }

    @Override
    public ExpandedNodeId[] readExpandedNodeIdArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        ExpandedNodeId[] values = new ExpandedNodeId[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readExpandedNodeId(field);
        }
        return values;
    }

    @Override
    public StatusCode[] readStatusCodeArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        StatusCode[] values = new StatusCode[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readStatusCode(field);
        }
        return values;
    }

    @Override
    public QualifiedName[] readQualifiedNameArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        QualifiedName[] values = new QualifiedName[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readQualifiedName(field);
        }
        return values;
    }

    @Override
    public LocalizedText[] readLocalizedTextArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        LocalizedText[] values = new LocalizedText[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readLocalizedText(field);
        }
        return values;
    }

    @Override
    public ExtensionObject[] readExtensionObjectArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        ExtensionObject[] values = new ExtensionObject[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readExtensionObject(field);
        }
        return values;
    }

    @Override
    public DataValue[] readDataValueArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        DataValue[] values = new DataValue[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readDataValue(field);
        }
        return values;
    }

    @Override
    public Variant[] readVariantArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        Variant[] values = new Variant[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readVariant(field);
        }
        return values;
    }

    @Override
    public DiagnosticInfo[] readDiagnosticInfoArray(String field) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        DiagnosticInfo[] values = new DiagnosticInfo[length];
        for (int i = 0; i < length; ++i) {
            values[i] = this.readDiagnosticInfo(field);
        }
        return values;
    }

    @Override
    public Object[] readStructArray(String field, NodeId dataTypeId) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        OpcUaBinaryDataTypeCodec binaryCodec = (OpcUaBinaryDataTypeCodec)OpcUaDataTypeManager.getInstance().getCodec(OpcUaDefaultBinaryEncoding.ENCODING_NAME, dataTypeId);
        if (binaryCodec == null) {
            throw new UaSerializationException(0x80070000L, "no codec registered: " + dataTypeId);
        }
        Class clazz = binaryCodec.getType();
        Object array = Array.newInstance(clazz, length);
        for (int i = 0; i < length; ++i) {
            Object value = binaryCodec.decode(this.context, this);
            Array.set(array, i, value);
        }
        return (Object[])array;
    }

    @Override
    public Object[] readStructArray(String field, ExpandedNodeId dataTypeId) throws UaSerializationException {
        return dataTypeId.local(this.context.getNamespaceTable()).map(id -> this.readStructArray(field, (NodeId)id)).orElseThrow(() -> new UaSerializationException(0x80070000L, "no codec registered: " + dataTypeId));
    }

    private void checkArrayLength(int length) throws UaSerializationException {
        if (length > this.context.getEncodingLimits().getMaxArrayLength()) {
            throw new UaSerializationException(0x80080000L, String.format("max array length exceeded (length=%s, max=%s)", length, this.context.getEncodingLimits().getMaxArrayLength()));
        }
    }

    @Override
    public <T> T[] readArray(String field, Function<String, T> decoder, Class<T> clazz) throws UaSerializationException {
        int length = this.readInt32();
        if (length == -1) {
            return null;
        }
        this.checkArrayLength(length);
        Object[] array = (Object[])Array.newInstance(clazz, length);
        for (int i = 0; i < length; ++i) {
            array[i] = decoder.apply(field);
        }
        return array;
    }

    @Override
    public <T extends UaStructure> T readBuiltinStruct(String field, Class<T> clazz) throws UaSerializationException {
        try {
            BuiltinDataTypeCodec<?> codec = BuiltinDataTypeDictionary.getBuiltinCodec(clazz);
            if (codec == null) {
                throw new UaSerializationException(0x80070000L, "No codec registered:" + clazz);
            }
            Object value = codec.decode(this.context, this);
            return (T)value;
        }
        catch (ClassCastException e) {
            throw new UaSerializationException(0x80070000L, (Throwable)e);
        }
    }

    @Override
    public <T extends UaStructure> T[] readBuiltinStructArray(String field, Class<T> clazz) throws UaSerializationException {
        return this.readArray(field, s -> this.readBuiltinStruct((String)s, clazz), clazz);
    }
}

