/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x500.style.RFC4519Style;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.MiscPEMGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.util.DigestUtil;

public class CertificateUtil {
    public static final int SUBJECT_ALT_NAME_DNS_NAME = 2;
    public static final int SUBJECT_ALT_NAME_IP_ADDRESS = 7;
    public static final int SUBJECT_ALT_NAME_URI = 6;

    public static X509Certificate decodeCertificate(byte[] certificateBytes) throws UaException {
        Preconditions.checkNotNull((Object)certificateBytes, (Object)"certificateBytes cannot be null");
        return CertificateUtil.decodeCertificate(new ByteArrayInputStream(certificateBytes));
    }

    public static X509Certificate decodeCertificate(InputStream inputStream) throws UaException {
        return CertificateUtil.decodeCertificates(inputStream).get(0);
    }

    public static List<X509Certificate> decodeCertificates(byte[] certificateBytes) throws UaException {
        return CertificateUtil.decodeCertificates(new ByteArrayInputStream(certificateBytes));
    }

    public static List<X509Certificate> decodeCertificates(InputStream inputStream) throws UaException {
        CertificateFactory factory;
        Preconditions.checkNotNull((Object)inputStream, (Object)"inputStream cannot be null");
        try {
            factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new UaException(0x80020000L, (Throwable)e);
        }
        try {
            Collection<? extends Certificate> certificates = factory.generateCertificates(inputStream);
            return certificates.stream().map(X509Certificate.class::cast).collect(Collectors.toList());
        }
        catch (CertificateException e) {
            throw new UaException(2148663296L, (Throwable)e);
        }
    }

    public static PKCS10CertificationRequest generateCsr(KeyPair keyPair, X509Certificate certificate) throws Exception {
        JcaPKCS10CertificationRequestBuilder builder = new JcaPKCS10CertificationRequestBuilder(certificate.getSubjectX500Principal(), certificate.getPublicKey());
        GeneralNames subjectAltNames = new GeneralNames(CertificateUtil.getSubjectAltNames(certificate).toArray(new GeneralName[0]));
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
        builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate());
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(certificate.getSigAlgName());
        ContentSigner signer = signerBuilder.build(keyPair.getPrivate());
        return builder.build(signer);
    }

    public static PKCS10CertificationRequest generateCsr(KeyPair keyPair, String subjectName, String sanUri, List<String> sanDnsNames, List<String> sanIpAddresses, String signatureAlgorithm) throws Exception {
        X500Name subject = new X500Name(IETFUtils.rDNsFromString((String)subjectName, (X500NameStyle)RFC4519Style.INSTANCE));
        return CertificateUtil.generateCsr(keyPair, subject, sanUri, sanDnsNames, sanIpAddresses, signatureAlgorithm);
    }

    public static PKCS10CertificationRequest generateCsr(KeyPair keyPair, X500Name subject, String sanUri, List<String> sanDnsNames, List<String> sanIpAddresses, String signatureAlgorithm) throws Exception {
        PKCS10CertificationRequestBuilder builder = new PKCS10CertificationRequestBuilder(subject, SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()));
        ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>();
        generalNames.add(new GeneralName(6, sanUri));
        sanDnsNames.stream().map(n -> new GeneralName(2, n)).forEach(generalNames::add);
        sanIpAddresses.stream().map(n -> new GeneralName(7, n)).forEach(generalNames::add);
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(generalNames.toArray(new GeneralName[0])));
        builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate());
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(signatureAlgorithm);
        ContentSigner signer = signerBuilder.build(keyPair.getPrivate());
        return builder.build(signer);
    }

    public static String getCsrPem(PKCS10CertificationRequest csr) throws IOException {
        StringWriter stringWriter = new StringWriter();
        try (PemWriter pemWriter = new PemWriter((Writer)stringWriter);){
            pemWriter.writeObject((PemObjectGenerator)new MiscPEMGenerator((Object)csr));
            pemWriter.flush();
        }
        return stringWriter.toString();
    }

    private static List<GeneralName> getSubjectAltNames(X509Certificate certificate) {
        try {
            ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>();
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames == null) {
                subjectAltNames = Collections.emptyList();
            }
            for (List<?> idAndValue : subjectAltNames) {
                if (idAndValue == null || idAndValue.size() != 2) continue;
                Object id = idAndValue.get(0);
                String value = Objects.toString(idAndValue.get(1));
                if (Objects.equals(id, 2)) {
                    generalNames.add(new GeneralName(2, value));
                    continue;
                }
                if (Objects.equals(id, 7)) {
                    generalNames.add(new GeneralName(7, value));
                    continue;
                }
                if (!Objects.equals(id, 6)) continue;
                generalNames.add(new GeneralName(6, value));
            }
            return generalNames;
        }
        catch (CertificateParsingException e) {
            return Collections.emptyList();
        }
    }

    public static List<Object> getSubjectAltNameField(X509Certificate certificate, int field) {
        try {
            ArrayList<Object> values = new ArrayList<Object>();
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames == null) {
                subjectAltNames = Collections.emptyList();
            }
            for (List<?> idAndValue : subjectAltNames) {
                Object value;
                if (idAndValue == null || idAndValue.size() != 2 || !idAndValue.get(0).equals(field) || (value = idAndValue.get(1)) == null) continue;
                values.add(value);
            }
            return values;
        }
        catch (CertificateParsingException e) {
            return Collections.emptyList();
        }
    }

    public static Optional<String> getSanUri(X509Certificate certificate) {
        List<Object> values = CertificateUtil.getSubjectAltNameField(certificate, 6);
        return values.stream().filter(v -> v instanceof String).map(String.class::cast).findFirst();
    }

    public static List<String> getSanDnsNames(X509Certificate certificate) {
        List<Object> values = CertificateUtil.getSubjectAltNameField(certificate, 2);
        return values.stream().filter(v -> v instanceof String).map(String.class::cast).collect(Collectors.toList());
    }

    public static List<String> getSanIpAddresses(X509Certificate certificate) {
        List<Object> values = CertificateUtil.getSubjectAltNameField(certificate, 7);
        return values.stream().filter(v -> v instanceof String).map(String.class::cast).collect(Collectors.toList());
    }

    public static ByteString thumbprint(X509Certificate certificate) throws UaException {
        try {
            return ByteString.of(DigestUtil.sha1(certificate.getEncoded()));
        }
        catch (CertificateEncodingException e) {
            throw new UaException(2148663296L, (Throwable)e);
        }
    }
}

