/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class TranslateBrowsePathsToNodeIdsRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.TranslateBrowsePathsToNodeIdsRequest;
    public static final NodeId BinaryEncodingId = Identifiers.TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.TranslateBrowsePathsToNodeIdsRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final BrowsePath[] browsePaths;

    public TranslateBrowsePathsToNodeIdsRequest() {
        this.requestHeader = null;
        this.browsePaths = null;
    }

    public TranslateBrowsePathsToNodeIdsRequest(RequestHeader requestHeader, BrowsePath[] browsePaths) {
        this.requestHeader = requestHeader;
        this.browsePaths = browsePaths;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Nullable
    public BrowsePath[] getBrowsePaths() {
        return this.browsePaths;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("BrowsePaths", (Object)this.browsePaths).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<TranslateBrowsePathsToNodeIdsRequest> {
        @Override
        public Class<TranslateBrowsePathsToNodeIdsRequest> getType() {
            return TranslateBrowsePathsToNodeIdsRequest.class;
        }

        @Override
        public TranslateBrowsePathsToNodeIdsRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            BrowsePath[] browsePaths = (BrowsePath[])decoder.readBuiltinStructArray("BrowsePaths", BrowsePath.class);
            return new TranslateBrowsePathsToNodeIdsRequest(requestHeader, browsePaths);
        }

        @Override
        public void encode(TranslateBrowsePathsToNodeIdsRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeBuiltinStructArray("BrowsePaths", value.browsePaths, BrowsePath.class);
        }
    }
}

