/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class TimeZoneDataType
implements UaStructure {
    public static final NodeId TypeId = Identifiers.TimeZoneDataType;
    public static final NodeId BinaryEncodingId = Identifiers.TimeZoneDataType_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.TimeZoneDataType_Encoding_DefaultXml;
    protected final Short offset;
    protected final Boolean daylightSavingInOffset;

    public TimeZoneDataType() {
        this.offset = null;
        this.daylightSavingInOffset = null;
    }

    public TimeZoneDataType(Short offset, Boolean daylightSavingInOffset) {
        this.offset = offset;
        this.daylightSavingInOffset = daylightSavingInOffset;
    }

    public Short getOffset() {
        return this.offset;
    }

    public Boolean getDaylightSavingInOffset() {
        return this.daylightSavingInOffset;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Offset", (Object)this.offset).add("DaylightSavingInOffset", (Object)this.daylightSavingInOffset).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<TimeZoneDataType> {
        @Override
        public Class<TimeZoneDataType> getType() {
            return TimeZoneDataType.class;
        }

        @Override
        public TimeZoneDataType decode(UaDecoder decoder) throws UaSerializationException {
            Short offset = decoder.readInt16("Offset");
            Boolean daylightSavingInOffset = decoder.readBoolean("DaylightSavingInOffset");
            return new TimeZoneDataType(offset, daylightSavingInOffset);
        }

        @Override
        public void encode(TimeZoneDataType value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeInt16("Offset", value.offset);
            encoder.writeBoolean("DaylightSavingInOffset", value.daylightSavingInOffset);
        }
    }
}

