/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;

public class SessionSecurityDiagnosticsDataType
implements UaStructure {
    public static final NodeId TypeId = Identifiers.SessionSecurityDiagnosticsDataType;
    public static final NodeId BinaryEncodingId = Identifiers.SessionSecurityDiagnosticsDataType_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.SessionSecurityDiagnosticsDataType_Encoding_DefaultXml;
    protected final NodeId sessionId;
    protected final String clientUserIdOfSession;
    protected final String[] clientUserIdHistory;
    protected final String authenticationMechanism;
    protected final String encoding;
    protected final String transportProtocol;
    protected final MessageSecurityMode securityMode;
    protected final String securityPolicyUri;
    protected final ByteString clientCertificate;

    public SessionSecurityDiagnosticsDataType() {
        this.sessionId = null;
        this.clientUserIdOfSession = null;
        this.clientUserIdHistory = null;
        this.authenticationMechanism = null;
        this.encoding = null;
        this.transportProtocol = null;
        this.securityMode = null;
        this.securityPolicyUri = null;
        this.clientCertificate = null;
    }

    public SessionSecurityDiagnosticsDataType(NodeId sessionId, String clientUserIdOfSession, String[] clientUserIdHistory, String authenticationMechanism, String encoding, String transportProtocol, MessageSecurityMode securityMode, String securityPolicyUri, ByteString clientCertificate) {
        this.sessionId = sessionId;
        this.clientUserIdOfSession = clientUserIdOfSession;
        this.clientUserIdHistory = clientUserIdHistory;
        this.authenticationMechanism = authenticationMechanism;
        this.encoding = encoding;
        this.transportProtocol = transportProtocol;
        this.securityMode = securityMode;
        this.securityPolicyUri = securityPolicyUri;
        this.clientCertificate = clientCertificate;
    }

    public NodeId getSessionId() {
        return this.sessionId;
    }

    public String getClientUserIdOfSession() {
        return this.clientUserIdOfSession;
    }

    @Nullable
    public String[] getClientUserIdHistory() {
        return this.clientUserIdHistory;
    }

    public String getAuthenticationMechanism() {
        return this.authenticationMechanism;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public String getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public ByteString getClientCertificate() {
        return this.clientCertificate;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("SessionId", (Object)this.sessionId).add("ClientUserIdOfSession", (Object)this.clientUserIdOfSession).add("ClientUserIdHistory", (Object)this.clientUserIdHistory).add("AuthenticationMechanism", (Object)this.authenticationMechanism).add("Encoding", (Object)this.encoding).add("TransportProtocol", (Object)this.transportProtocol).add("SecurityMode", (Object)this.securityMode).add("SecurityPolicyUri", (Object)this.securityPolicyUri).add("ClientCertificate", (Object)this.clientCertificate).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<SessionSecurityDiagnosticsDataType> {
        @Override
        public Class<SessionSecurityDiagnosticsDataType> getType() {
            return SessionSecurityDiagnosticsDataType.class;
        }

        @Override
        public SessionSecurityDiagnosticsDataType decode(UaDecoder decoder) throws UaSerializationException {
            NodeId sessionId = decoder.readNodeId("SessionId");
            String clientUserIdOfSession = decoder.readString("ClientUserIdOfSession");
            String[] clientUserIdHistory = decoder.readArray("ClientUserIdHistory", decoder::readString, String.class);
            String authenticationMechanism = decoder.readString("AuthenticationMechanism");
            String encoding = decoder.readString("Encoding");
            String transportProtocol = decoder.readString("TransportProtocol");
            MessageSecurityMode securityMode = MessageSecurityMode.from(decoder.readInt32("SecurityMode"));
            String securityPolicyUri = decoder.readString("SecurityPolicyUri");
            ByteString clientCertificate = decoder.readByteString("ClientCertificate");
            return new SessionSecurityDiagnosticsDataType(sessionId, clientUserIdOfSession, clientUserIdHistory, authenticationMechanism, encoding, transportProtocol, securityMode, securityPolicyUri, clientCertificate);
        }

        @Override
        public void encode(SessionSecurityDiagnosticsDataType value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeNodeId("SessionId", value.sessionId);
            encoder.writeString("ClientUserIdOfSession", value.clientUserIdOfSession);
            encoder.writeArray("ClientUserIdHistory", value.clientUserIdHistory, encoder::writeString);
            encoder.writeString("AuthenticationMechanism", value.authenticationMechanism);
            encoder.writeString("Encoding", value.encoding);
            encoder.writeString("TransportProtocol", value.transportProtocol);
            encoder.writeInt32("SecurityMode", value.securityMode != null ? value.securityMode.getValue() : 0);
            encoder.writeString("SecurityPolicyUri", value.securityPolicyUri);
            encoder.writeByteString("ClientCertificate", value.clientCertificate);
        }
    }
}

