/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.NodeTypeDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;

public class QueryFirstRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.QueryFirstRequest;
    public static final NodeId BinaryEncodingId = Identifiers.QueryFirstRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.QueryFirstRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final ViewDescription view;
    protected final NodeTypeDescription[] nodeTypes;
    protected final ContentFilter filter;
    protected final UInteger maxDataSetsToReturn;
    protected final UInteger maxReferencesToReturn;

    public QueryFirstRequest() {
        this.requestHeader = null;
        this.view = null;
        this.nodeTypes = null;
        this.filter = null;
        this.maxDataSetsToReturn = null;
        this.maxReferencesToReturn = null;
    }

    public QueryFirstRequest(RequestHeader requestHeader, ViewDescription view, NodeTypeDescription[] nodeTypes, ContentFilter filter, UInteger maxDataSetsToReturn, UInteger maxReferencesToReturn) {
        this.requestHeader = requestHeader;
        this.view = view;
        this.nodeTypes = nodeTypes;
        this.filter = filter;
        this.maxDataSetsToReturn = maxDataSetsToReturn;
        this.maxReferencesToReturn = maxReferencesToReturn;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ViewDescription getView() {
        return this.view;
    }

    @Nullable
    public NodeTypeDescription[] getNodeTypes() {
        return this.nodeTypes;
    }

    public ContentFilter getFilter() {
        return this.filter;
    }

    public UInteger getMaxDataSetsToReturn() {
        return this.maxDataSetsToReturn;
    }

    public UInteger getMaxReferencesToReturn() {
        return this.maxReferencesToReturn;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("View", (Object)this.view).add("NodeTypes", (Object)this.nodeTypes).add("Filter", (Object)this.filter).add("MaxDataSetsToReturn", (Object)this.maxDataSetsToReturn).add("MaxReferencesToReturn", (Object)this.maxReferencesToReturn).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<QueryFirstRequest> {
        @Override
        public Class<QueryFirstRequest> getType() {
            return QueryFirstRequest.class;
        }

        @Override
        public QueryFirstRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            ViewDescription view = decoder.readBuiltinStruct("View", ViewDescription.class);
            NodeTypeDescription[] nodeTypes = (NodeTypeDescription[])decoder.readBuiltinStructArray("NodeTypes", NodeTypeDescription.class);
            ContentFilter filter = decoder.readBuiltinStruct("Filter", ContentFilter.class);
            UInteger maxDataSetsToReturn = decoder.readUInt32("MaxDataSetsToReturn");
            UInteger maxReferencesToReturn = decoder.readUInt32("MaxReferencesToReturn");
            return new QueryFirstRequest(requestHeader, view, nodeTypes, filter, maxDataSetsToReturn, maxReferencesToReturn);
        }

        @Override
        public void encode(QueryFirstRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeBuiltinStruct("View", value.view, ViewDescription.class);
            encoder.writeBuiltinStructArray("NodeTypes", value.nodeTypes, NodeTypeDescription.class);
            encoder.writeBuiltinStruct("Filter", value.filter, ContentFilter.class);
            encoder.writeUInt32("MaxDataSetsToReturn", value.maxDataSetsToReturn);
            encoder.writeUInt32("MaxReferencesToReturn", value.maxReferencesToReturn);
        }
    }
}

