/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

public class ModifySubscriptionResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.ModifySubscriptionResponse;
    public static final NodeId BinaryEncodingId = Identifiers.ModifySubscriptionResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ModifySubscriptionResponse_Encoding_DefaultXml;
    protected final ResponseHeader responseHeader;
    protected final Double revisedPublishingInterval;
    protected final UInteger revisedLifetimeCount;
    protected final UInteger revisedMaxKeepAliveCount;

    public ModifySubscriptionResponse() {
        this.responseHeader = null;
        this.revisedPublishingInterval = null;
        this.revisedLifetimeCount = null;
        this.revisedMaxKeepAliveCount = null;
    }

    public ModifySubscriptionResponse(ResponseHeader responseHeader, Double revisedPublishingInterval, UInteger revisedLifetimeCount, UInteger revisedMaxKeepAliveCount) {
        this.responseHeader = responseHeader;
        this.revisedPublishingInterval = revisedPublishingInterval;
        this.revisedLifetimeCount = revisedLifetimeCount;
        this.revisedMaxKeepAliveCount = revisedMaxKeepAliveCount;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public Double getRevisedPublishingInterval() {
        return this.revisedPublishingInterval;
    }

    public UInteger getRevisedLifetimeCount() {
        return this.revisedLifetimeCount;
    }

    public UInteger getRevisedMaxKeepAliveCount() {
        return this.revisedMaxKeepAliveCount;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this.responseHeader).add("RevisedPublishingInterval", (Object)this.revisedPublishingInterval).add("RevisedLifetimeCount", (Object)this.revisedLifetimeCount).add("RevisedMaxKeepAliveCount", (Object)this.revisedMaxKeepAliveCount).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ModifySubscriptionResponse> {
        @Override
        public Class<ModifySubscriptionResponse> getType() {
            return ModifySubscriptionResponse.class;
        }

        @Override
        public ModifySubscriptionResponse decode(UaDecoder decoder) throws UaSerializationException {
            ResponseHeader responseHeader = decoder.readBuiltinStruct("ResponseHeader", ResponseHeader.class);
            Double revisedPublishingInterval = decoder.readDouble("RevisedPublishingInterval");
            UInteger revisedLifetimeCount = decoder.readUInt32("RevisedLifetimeCount");
            UInteger revisedMaxKeepAliveCount = decoder.readUInt32("RevisedMaxKeepAliveCount");
            return new ModifySubscriptionResponse(responseHeader, revisedPublishingInterval, revisedLifetimeCount, revisedMaxKeepAliveCount);
        }

        @Override
        public void encode(ModifySubscriptionResponse value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("ResponseHeader", value.responseHeader, ResponseHeader.class);
            encoder.writeDouble("RevisedPublishingInterval", value.revisedPublishingInterval);
            encoder.writeUInt32("RevisedLifetimeCount", value.revisedLifetimeCount);
            encoder.writeUInt32("RevisedMaxKeepAliveCount", value.revisedMaxKeepAliveCount);
        }
    }
}

