/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class HistoryUpdateRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.HistoryUpdateRequest;
    public static final NodeId BinaryEncodingId = Identifiers.HistoryUpdateRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.HistoryUpdateRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final ExtensionObject[] historyUpdateDetails;

    public HistoryUpdateRequest() {
        this.requestHeader = null;
        this.historyUpdateDetails = null;
    }

    public HistoryUpdateRequest(RequestHeader requestHeader, ExtensionObject[] historyUpdateDetails) {
        this.requestHeader = requestHeader;
        this.historyUpdateDetails = historyUpdateDetails;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Nullable
    public ExtensionObject[] getHistoryUpdateDetails() {
        return this.historyUpdateDetails;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("HistoryUpdateDetails", (Object)this.historyUpdateDetails).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<HistoryUpdateRequest> {
        @Override
        public Class<HistoryUpdateRequest> getType() {
            return HistoryUpdateRequest.class;
        }

        @Override
        public HistoryUpdateRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            ExtensionObject[] historyUpdateDetails = decoder.readArray("HistoryUpdateDetails", decoder::readExtensionObject, ExtensionObject.class);
            return new HistoryUpdateRequest(requestHeader, historyUpdateDetails);
        }

        @Override
        public void encode(HistoryUpdateRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeArray("HistoryUpdateDetails", value.historyUpdateDetails, encoder::writeExtensionObject);
        }
    }
}

