/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryData;
import org.eclipse.milo.opcua.stack.core.types.structured.ModificationInfo;

public class HistoryModifiedData
extends HistoryData {
    public static final NodeId TypeId = Identifiers.HistoryModifiedData;
    public static final NodeId BinaryEncodingId = Identifiers.HistoryModifiedData_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.HistoryModifiedData_Encoding_DefaultXml;
    protected final DataValue[] dataValues;
    protected final ModificationInfo[] modificationInfos;

    public HistoryModifiedData() {
        this.dataValues = null;
        this.modificationInfos = null;
    }

    public HistoryModifiedData(DataValue[] dataValues, ModificationInfo[] modificationInfos) {
        this.dataValues = dataValues;
        this.modificationInfos = modificationInfos;
    }

    @Override
    @Nullable
    public DataValue[] getDataValues() {
        return this.dataValues;
    }

    @Nullable
    public ModificationInfo[] getModificationInfos() {
        return this.modificationInfos;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("DataValues", (Object)this.dataValues).add("ModificationInfos", (Object)this.modificationInfos).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<HistoryModifiedData> {
        @Override
        public Class<HistoryModifiedData> getType() {
            return HistoryModifiedData.class;
        }

        @Override
        public HistoryModifiedData decode(UaDecoder decoder) throws UaSerializationException {
            DataValue[] dataValues = decoder.readArray("DataValues", decoder::readDataValue, DataValue.class);
            ModificationInfo[] modificationInfos = (ModificationInfo[])decoder.readBuiltinStructArray("ModificationInfos", ModificationInfo.class);
            return new HistoryModifiedData(dataValues, modificationInfos);
        }

        @Override
        public void encode(HistoryModifiedData value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeArray("DataValues", value.dataValues, encoder::writeDataValue);
            encoder.writeBuiltinStructArray("ModificationInfos", value.modificationInfos, ModificationInfo.class);
        }
    }
}

