/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class FindServersRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.FindServersRequest;
    public static final NodeId BinaryEncodingId = Identifiers.FindServersRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.FindServersRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final String endpointUrl;
    protected final String[] localeIds;
    protected final String[] serverUris;

    public FindServersRequest() {
        this.requestHeader = null;
        this.endpointUrl = null;
        this.localeIds = null;
        this.serverUris = null;
    }

    public FindServersRequest(RequestHeader requestHeader, String endpointUrl, String[] localeIds, String[] serverUris) {
        this.requestHeader = requestHeader;
        this.endpointUrl = endpointUrl;
        this.localeIds = localeIds;
        this.serverUris = serverUris;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    @Nullable
    public String[] getLocaleIds() {
        return this.localeIds;
    }

    @Nullable
    public String[] getServerUris() {
        return this.serverUris;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("EndpointUrl", (Object)this.endpointUrl).add("LocaleIds", (Object)this.localeIds).add("ServerUris", (Object)this.serverUris).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<FindServersRequest> {
        @Override
        public Class<FindServersRequest> getType() {
            return FindServersRequest.class;
        }

        @Override
        public FindServersRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            String endpointUrl = decoder.readString("EndpointUrl");
            String[] localeIds = decoder.readArray("LocaleIds", decoder::readString, String.class);
            String[] serverUris = decoder.readArray("ServerUris", decoder::readString, String.class);
            return new FindServersRequest(requestHeader, endpointUrl, localeIds, serverUris);
        }

        @Override
        public void encode(FindServersRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeString("EndpointUrl", value.endpointUrl);
            encoder.writeArray("LocaleIds", value.localeIds, encoder::writeString);
            encoder.writeArray("ServerUris", value.serverUris, encoder::writeString);
        }
    }
}

