/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

public final class ByteString
implements Serializable {
    private static final long serialVersionUID = 451472015617419665L;
    public static final ByteString NULL_VALUE = new ByteString(null);
    private final byte[] bytes;

    public ByteString(@Nullable byte[] bytes) {
        this.bytes = bytes;
    }

    public int length() {
        return this.bytes != null ? this.bytes.length : 0;
    }

    public boolean isNull() {
        return this.bytes == null;
    }

    public boolean isNullOrEmpty() {
        return this.bytes == null || this.bytes.length == 0;
    }

    public boolean isNotNull() {
        return this.bytes != null;
    }

    @Nullable
    public byte[] bytes() {
        return this.bytes;
    }

    @Nonnull
    public byte[] bytesOrElse(@Nonnull byte[] other) {
        return this.bytes != null ? this.bytes : other;
    }

    @Nonnull
    public byte[] bytesOrEmpty() {
        return this.bytesOrElse(new byte[0]);
    }

    @Nullable
    public UByte[] uBytes() {
        if (this.bytes == null) {
            return null;
        }
        UByte[] bs = new UByte[this.bytes.length];
        for (int i = 0; i < this.bytes.length; ++i) {
            bs[i] = Unsigned.ubyte(this.bytes[i]);
        }
        return bs;
    }

    @Nonnull
    public UByte[] uBytesOrElse(@Nonnull UByte[] other) {
        UByte[] ubs = this.uBytes();
        return ubs != null ? ubs : other;
    }

    @Nonnull
    public UByte[] uBytesOrEmpty() {
        return this.uBytesOrElse(new UByte[0]);
    }

    public byte byteAt(int index) {
        if (this.bytes == null) {
            throw new IndexOutOfBoundsException("index=" + index);
        }
        return this.bytes[index];
    }

    public UByte uByteAt(int index) {
        return Unsigned.ubyte(this.byteAt(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteString that = (ByteString)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return this.bytes != null ? Arrays.hashCode(this.bytes) : 0;
    }

    public static ByteString of(byte[] bs) {
        return new ByteString(bs);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bytes", (Object)Arrays.toString(this.bytes)).toString();
    }
}

