/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

final class UInt16Conversions {
    private UInt16Conversions() {
    }

    @Nonnull
    static Boolean uInt16ToBoolean(@Nonnull UShort us) {
        return us.intValue() != 0;
    }

    @Nullable
    static UByte uInt16ToByte(@Nonnull UShort us) {
        int i = us.intValue();
        if (i <= 255) {
            return Unsigned.ubyte((int)i);
        }
        return null;
    }

    @Nonnull
    static Double uInt16ToDouble(@Nonnull UShort us) {
        return us.doubleValue();
    }

    @Nonnull
    static Float uInt16ToFloat(@Nonnull UShort us) {
        return Float.valueOf(us.floatValue());
    }

    @Nullable
    static Short uInt16ToInt16(@Nonnull UShort us) {
        int i = us.intValue();
        if (i <= Short.MAX_VALUE) {
            return (short)i;
        }
        return null;
    }

    @Nonnull
    static Integer uInt16ToInt32(@Nonnull UShort us) {
        return us.intValue();
    }

    @Nonnull
    static Long uInt16ToInt64(@Nonnull UShort us) {
        return us.longValue();
    }

    @Nullable
    static Byte uInt16ToSByte(@Nonnull UShort us) {
        int i = us.intValue();
        if (i <= 127) {
            return (byte)i;
        }
        return null;
    }

    @Nonnull
    static StatusCode uInt16ToStatusCode(@Nonnull UShort us) {
        return new StatusCode(us.longValue() << 16);
    }

    @Nonnull
    static String uInt16ToString(@Nonnull UShort us) {
        return us.toString();
    }

    @Nonnull
    static UInteger uInt16ToUInt32(@Nonnull UShort us) {
        return Unsigned.uint((int)us.intValue());
    }

    @Nonnull
    static ULong uInt16ToUInt64(@Nonnull UShort us) {
        return Unsigned.ulong((long)us.longValue());
    }

    @Nullable
    static Object convert(@Nullable Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof UShort) {
            UShort us = (UShort)o;
            return implicit ? UInt16Conversions.implicitConversion(us, targetType) : UInt16Conversions.explicitConversion(us, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull UShort us, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return UInt16Conversions.uInt16ToBoolean(us);
            }
            case Byte: {
                return UInt16Conversions.uInt16ToByte(us);
            }
            case SByte: {
                return UInt16Conversions.uInt16ToSByte(us);
            }
            case String: {
                return UInt16Conversions.uInt16ToString(us);
            }
        }
        return UInt16Conversions.implicitConversion(us, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull UShort us, BuiltinDataType targetType) {
        switch (targetType) {
            case Double: {
                return UInt16Conversions.uInt16ToDouble(us);
            }
            case Float: {
                return UInt16Conversions.uInt16ToFloat(us);
            }
            case Int16: {
                return UInt16Conversions.uInt16ToInt16(us);
            }
            case Int32: {
                return UInt16Conversions.uInt16ToInt32(us);
            }
            case Int64: {
                return UInt16Conversions.uInt16ToInt64(us);
            }
            case StatusCode: {
                return UInt16Conversions.uInt16ToStatusCode(us);
            }
            case UInt32: {
                return UInt16Conversions.uInt16ToUInt32(us);
            }
            case UInt64: {
                return UInt16Conversions.uInt16ToUInt64(us);
            }
        }
        return null;
    }
}

