/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

final class Int16Conversions {
    private Int16Conversions() {
    }

    @Nonnull
    static Boolean int16ToBoolean(@Nonnull Short s) {
        return s != 0;
    }

    @Nullable
    static UByte int16ToByte(@Nonnull Short s) {
        if (s >= 0 && s <= 255) {
            return Unsigned.ubyte((short)s);
        }
        return null;
    }

    @Nonnull
    static Double int16ToDouble(@Nonnull Short s) {
        return (double)s;
    }

    @Nonnull
    static Float int16ToFloat(@Nonnull Short s) {
        return Float.valueOf(s.shortValue());
    }

    @Nonnull
    static Integer int16ToInt32(@Nonnull Short s) {
        return (int)s;
    }

    @Nonnull
    static Long int16ToInt64(@Nonnull Short s) {
        return (long)s;
    }

    @Nullable
    static Byte int16ToSByte(@Nonnull Short s) {
        if (s >= -128 && s <= 127) {
            return s.byteValue();
        }
        return null;
    }

    @Nonnull
    static String int16ToString(@Nonnull Short s) {
        return s.toString();
    }

    @Nullable
    static UShort int16ToUInt16(@Nonnull Short s) {
        if (s >= 0) {
            return Unsigned.ushort((short)s);
        }
        return null;
    }

    @Nullable
    static UInteger int16ToUInt32(@Nonnull Short s) {
        if (s >= 0) {
            return Unsigned.uint((int)s.shortValue());
        }
        return null;
    }

    @Nullable
    static ULong int16ToUInt64(@Nonnull Short s) {
        if (s >= 0) {
            return Unsigned.ulong((long)s.shortValue());
        }
        return null;
    }

    @Nullable
    static Object convert(@Nullable Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof Short) {
            Short s = (Short)o;
            return implicit ? Int16Conversions.implicitConversion(s, targetType) : Int16Conversions.explicitConversion(s, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull Short s, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return Int16Conversions.int16ToBoolean(s);
            }
            case Byte: {
                return Int16Conversions.int16ToByte(s);
            }
            case SByte: {
                return Int16Conversions.int16ToSByte(s);
            }
            case String: {
                return Int16Conversions.int16ToString(s);
            }
            case UInt16: {
                return Int16Conversions.int16ToUInt16(s);
            }
        }
        return Int16Conversions.implicitConversion(s, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull Short s, BuiltinDataType targetType) {
        switch (targetType) {
            case Double: {
                return Int16Conversions.int16ToDouble(s);
            }
            case Float: {
                return Int16Conversions.int16ToFloat(s);
            }
            case Int32: {
                return Int16Conversions.int16ToInt32(s);
            }
            case Int64: {
                return Int16Conversions.int16ToInt64(s);
            }
            case UInt32: {
                return Int16Conversions.int16ToUInt32(s);
            }
            case UInt64: {
                return Int16Conversions.int16ToUInt64(s);
            }
        }
        return null;
    }
}

