/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

final class DoubleConversions {
    private DoubleConversions() {
    }

    @Nonnull
    static Boolean doubleToBoolean(@Nonnull Double d) {
        return d != 0.0;
    }

    @Nullable
    static UByte doubleToByte(@Nonnull Double d) {
        long rounded = Math.round(d);
        if (rounded >= 0L && rounded <= 255L) {
            return Unsigned.ubyte((long)rounded);
        }
        return null;
    }

    @Nullable
    static Float doubleToFloat(@Nonnull Double d) {
        if (d >= -3.4028234663852886E38 && d <= 3.4028234663852886E38) {
            return Float.valueOf(d.floatValue());
        }
        return null;
    }

    @Nullable
    static Short doubleToInt16(@Nonnull Double d) {
        long rounded = Math.round(d);
        if (rounded >= -32768L && rounded <= 32767L) {
            return (short)rounded;
        }
        return null;
    }

    @Nullable
    static Integer doubleToInt32(@Nonnull Double d) {
        long rounded = Math.round(d);
        if (rounded >= Integer.MIN_VALUE && rounded <= Integer.MAX_VALUE) {
            return (int)rounded;
        }
        return null;
    }

    @Nullable
    static Long doubleToInt64(@Nonnull Double d) {
        if (d >= -9.223372036854776E18 && d <= 9.223372036854776E18) {
            return Math.round(d);
        }
        return null;
    }

    @Nullable
    static Byte doubleToSByte(@Nonnull Double d) {
        long rounded = Math.round(d);
        if (rounded >= -128L && rounded <= 127L) {
            return (byte)rounded;
        }
        return null;
    }

    @Nonnull
    static String doubleToString(@Nonnull Double d) {
        return d.toString();
    }

    @Nullable
    static UShort doubleToUInt16(@Nonnull Double d) {
        long rounded = Math.round(d);
        if (rounded >= 0L && rounded <= 65535L) {
            return Unsigned.ushort((int)((int)rounded));
        }
        return null;
    }

    @Nullable
    static UInteger doubleToUInt32(@Nonnull Double d) {
        long rounded = Math.round(d);
        if (rounded >= 0L && rounded <= 0xFFFFFFFFL) {
            return Unsigned.uint((long)rounded);
        }
        return null;
    }

    @Nullable
    static ULong doubleToUInt64(@Nonnull Double d) {
        long rounded = Math.round(d);
        if (rounded >= 0L) {
            return Unsigned.ulong((long)rounded);
        }
        return null;
    }

    @Nullable
    static Object convert(@Nullable Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof Double) {
            Double d = (Double)o;
            return implicit ? DoubleConversions.implicitConversion(d, targetType) : DoubleConversions.explicitConversion(d, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull Double d, BuiltinDataType targetType) {
        switch (targetType) {
            case Boolean: {
                return DoubleConversions.doubleToBoolean(d);
            }
            case Byte: {
                return DoubleConversions.doubleToByte(d);
            }
            case Float: {
                return DoubleConversions.doubleToFloat(d);
            }
            case Int16: {
                return DoubleConversions.doubleToInt16(d);
            }
            case Int32: {
                return DoubleConversions.doubleToInt32(d);
            }
            case Int64: {
                return DoubleConversions.doubleToInt64(d);
            }
            case SByte: {
                return DoubleConversions.doubleToSByte(d);
            }
            case String: {
                return DoubleConversions.doubleToString(d);
            }
            case UInt16: {
                return DoubleConversions.doubleToUInt16(d);
            }
            case UInt32: {
                return DoubleConversions.doubleToUInt32(d);
            }
            case UInt64: {
                return DoubleConversions.doubleToUInt64(d);
            }
        }
        return DoubleConversions.implicitConversion(d, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull Double d, BuiltinDataType targetType) {
        return null;
    }
}

