/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeAclsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private String errorMessage;
    private List<DescribeAclsResource> resources;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("resources", new ArrayOf(DescribeAclsResource.SCHEMA_0), "Each Resource that is referenced in an ACL."));
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("resources", new ArrayOf(DescribeAclsResource.SCHEMA_1), "Each Resource that is referenced in an ACL."));
    public static final Schema SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("resources", new CompactArrayOf(DescribeAclsResource.SCHEMA_2), "Each Resource that is referenced in an ACL."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};

    public DescribeAclsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeAclsResponseData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public DescribeAclsResponseData(JsonNode _node, short _version) {
        this.fromJson(_node, _version);
    }

    public DescribeAclsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.resources = new ArrayList<DescribeAclsResource>(0);
    }

    @Override
    public short apiKey() {
        return 29;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        ArrayList<DescribeAclsResource> newCollection;
        int arrayLength;
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
        }
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field resources was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribeAclsResource(_readable, _version));
            }
            this.resources = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field resources was serialized as null");
            }
            newCollection = new ArrayList<DescribeAclsResource>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DescribeAclsResource(_readable, _version));
            }
            this.resources = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            if (_version >= 2) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeShort((short)-1);
            }
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.resources.size() + 1);
            _stringBytes = this.resources.iterator();
            while (_stringBytes.hasNext()) {
                DescribeAclsResource resourcesElement = (DescribeAclsResource)_stringBytes.next();
                resourcesElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.resources.size());
            _stringBytes = this.resources.iterator();
            while (_stringBytes.hasNext()) {
                DescribeAclsResource resourcesElement = (DescribeAclsResource)_stringBytes.next();
                resourcesElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.errorCode = struct.getShort("error_code");
        this.errorMessage = struct.getString("error_message");
        Object[] _nestedObjects = struct.getArray("resources");
        this.resources = new ArrayList<DescribeAclsResource>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.resources.add(new DescribeAclsResource((Struct)nestedObject, _version));
        }
        if (_version >= 2 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 2) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        struct.set("error_code", (Object)this.errorCode);
        struct.set("error_message", (Object)this.errorMessage);
        Struct[] _nestedObjects = new Struct[this.resources.size()];
        int i = 0;
        for (DescribeAclsResource element : this.resources) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("resources", (Object)_nestedObjects);
        if (_version >= 2) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public void fromJson(JsonNode _node, short _version) {
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("DescribeAclsResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        this.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "DescribeAclsResponseData");
        JsonNode _errorCodeNode = _node.get("errorCode");
        if (_errorCodeNode == null) {
            throw new RuntimeException("DescribeAclsResponseData: unable to locate field 'errorCode', which is mandatory in version " + _version);
        }
        this.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "DescribeAclsResponseData");
        JsonNode _errorMessageNode = _node.get("errorMessage");
        if (_errorMessageNode == null) {
            throw new RuntimeException("DescribeAclsResponseData: unable to locate field 'errorMessage', which is mandatory in version " + _version);
        }
        if (_errorMessageNode.isNull()) {
            this.errorMessage = null;
        } else {
            if (!_errorMessageNode.isTextual()) {
                throw new RuntimeException("DescribeAclsResponseData expected a string type, but got " + _node.getNodeType());
            }
            this.errorMessage = _errorMessageNode.asText();
        }
        JsonNode _resourcesNode = _node.get("resources");
        if (_resourcesNode == null) {
            throw new RuntimeException("DescribeAclsResponseData: unable to locate field 'resources', which is mandatory in version " + _version);
        }
        if (!_resourcesNode.isArray()) {
            throw new RuntimeException("DescribeAclsResponseData expected a JSON array, but got " + _node.getNodeType());
        }
        this.resources = new ArrayList<DescribeAclsResource>();
        for (JsonNode _element : _resourcesNode) {
            this.resources.add(new DescribeAclsResource(_element, _version));
        }
    }

    @Override
    public JsonNode toJson(short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", (JsonNode)new IntNode(this.throttleTimeMs));
        _node.set("errorCode", (JsonNode)new ShortNode(this.errorCode));
        if (this.errorMessage == null) {
            _node.set("errorMessage", (JsonNode)NullNode.instance);
        } else {
            _node.set("errorMessage", (JsonNode)new TextNode(this.errorMessage));
        }
        ArrayNode _resourcesArray = new ArrayNode(JsonNodeFactory.instance);
        for (DescribeAclsResource _element : this.resources) {
            _resourcesArray.add(_element.toJson(_version));
        }
        _node.set("resources", (JsonNode)_resourcesArray);
        return _node;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        _size += 2;
        if (this.errorMessage == null) {
            _size = _version >= 2 ? ++_size : (_size += 2);
        } else {
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
        }
        int _arraySize = 0;
        _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.resources.size() + 1)) : (_arraySize += 4);
        for (DescribeAclsResource resourcesElement : this.resources) {
            _arraySize += resourcesElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 2) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeAclsResponseData)) {
            return false;
        }
        DescribeAclsResponseData other = (DescribeAclsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        return !(this.resources == null ? other.resources != null : !this.resources.equals(other.resources));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.resources == null ? 0 : this.resources.hashCode());
        return hashCode;
    }

    @Override
    public DescribeAclsResponseData duplicate() {
        DescribeAclsResponseData _duplicate = new DescribeAclsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        ArrayList<DescribeAclsResource> newResources = new ArrayList<DescribeAclsResource>(this.resources.size());
        for (DescribeAclsResource _element : this.resources) {
            newResources.add(_element.duplicate());
        }
        _duplicate.resources = newResources;
        return _duplicate;
    }

    public String toString() {
        return "DescribeAclsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", resources=" + MessageUtil.deepToString(this.resources.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<DescribeAclsResource> resources() {
        return this.resources;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeAclsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeAclsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeAclsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeAclsResponseData setResources(List<DescribeAclsResource> v) {
        this.resources = v;
        return this;
    }

    public static class AclDescription
    implements Message {
        private String principal;
        private String host;
        private byte operation;
        private byte permissionType;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public AclDescription(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public AclDescription(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public AclDescription(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public AclDescription() {
            this.principal = "";
            this.host = "";
            this.operation = 0;
            this.permissionType = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AclDescription");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field principal was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principal had invalid length " + length);
            }
            this.principal = _readable.readString(length);
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.operation = _readable.readByte();
            this.permissionType = _readable.readByte();
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.principal);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.host);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.operation);
            _writable.writeByte(this.permissionType);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AclDescription");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.principal = struct.getString("principal");
            this.host = struct.getString("host");
            this.operation = struct.getByte("operation");
            this.permissionType = struct.getByte("permission_type");
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of AclDescription");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("principal", (Object)this.principal);
            struct.set("host", (Object)this.host);
            struct.set("operation", (Object)this.operation);
            struct.set("permission_type", (Object)this.permissionType);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public void fromJson(JsonNode _node, short _version) {
            JsonNode _principalNode = _node.get("principal");
            if (_principalNode == null) {
                throw new RuntimeException("AclDescription: unable to locate field 'principal', which is mandatory in version " + _version);
            }
            if (!_principalNode.isTextual()) {
                throw new RuntimeException("AclDescription expected a string type, but got " + _node.getNodeType());
            }
            this.principal = _principalNode.asText();
            JsonNode _hostNode = _node.get("host");
            if (_hostNode == null) {
                throw new RuntimeException("AclDescription: unable to locate field 'host', which is mandatory in version " + _version);
            }
            if (!_hostNode.isTextual()) {
                throw new RuntimeException("AclDescription expected a string type, but got " + _node.getNodeType());
            }
            this.host = _hostNode.asText();
            JsonNode _operationNode = _node.get("operation");
            if (_operationNode == null) {
                throw new RuntimeException("AclDescription: unable to locate field 'operation', which is mandatory in version " + _version);
            }
            this.operation = MessageUtil.jsonNodeToByte(_operationNode, "AclDescription");
            JsonNode _permissionTypeNode = _node.get("permissionType");
            if (_permissionTypeNode == null) {
                throw new RuntimeException("AclDescription: unable to locate field 'permissionType', which is mandatory in version " + _version);
            }
            this.permissionType = MessageUtil.jsonNodeToByte(_permissionTypeNode, "AclDescription");
        }

        @Override
        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("principal", (JsonNode)new TextNode(this.principal));
            _node.set("host", (JsonNode)new TextNode(this.host));
            _node.set("operation", (JsonNode)new ShortNode((short)this.operation));
            _node.set("permissionType", (JsonNode)new ShortNode((short)this.permissionType));
            return _node;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AclDescription");
            }
            byte[] _stringBytes = this.principal.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'principal' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principal, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            ++_size;
            ++_size;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AclDescription)) {
                return false;
            }
            AclDescription other = (AclDescription)obj;
            if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.operation != other.operation) {
                return false;
            }
            return this.permissionType == other.permissionType;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.principal == null ? 0 : this.principal.hashCode());
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + this.operation;
            hashCode = 31 * hashCode + this.permissionType;
            return hashCode;
        }

        @Override
        public AclDescription duplicate() {
            AclDescription _duplicate = new AclDescription();
            _duplicate.principal = this.principal;
            _duplicate.host = this.host;
            _duplicate.operation = this.operation;
            _duplicate.permissionType = this.permissionType;
            return _duplicate;
        }

        public String toString() {
            return "AclDescription(principal=" + (this.principal == null ? "null" : "'" + this.principal.toString() + "'") + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
        }

        public String principal() {
            return this.principal;
        }

        public String host() {
            return this.host;
        }

        public byte operation() {
            return this.operation;
        }

        public byte permissionType() {
            return this.permissionType;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AclDescription setPrincipal(String v) {
            this.principal = v;
            return this;
        }

        public AclDescription setHost(String v) {
            this.host = v;
            return this;
        }

        public AclDescription setOperation(byte v) {
            this.operation = v;
            return this;
        }

        public AclDescription setPermissionType(byte v) {
            this.permissionType = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("principal", Type.STRING, "The ACL principal."), new Field("host", Type.STRING, "The ACL host."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The ACL permission type."));
            SCHEMA_2 = new Schema(new Field("principal", Type.COMPACT_STRING, "The ACL principal."), new Field("host", Type.COMPACT_STRING, "The ACL host."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The ACL permission type."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class DescribeAclsResource
    implements Message {
        private byte resourceType;
        private String resourceName;
        private byte patternType;
        private List<AclDescription> acls;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.STRING, "The resource name."), new Field("acls", new ArrayOf(AclDescription.SCHEMA_0), "The ACLs."));
        public static final Schema SCHEMA_1 = new Schema(new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.STRING, "The resource name."), new Field("pattern_type", Type.INT8, "The resource pattern type."), new Field("acls", new ArrayOf(AclDescription.SCHEMA_0), "The ACLs."));
        public static final Schema SCHEMA_2 = new Schema(new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.COMPACT_STRING, "The resource name."), new Field("pattern_type", Type.INT8, "The resource pattern type."), new Field("acls", new CompactArrayOf(AclDescription.SCHEMA_2), "The ACLs."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};

        public DescribeAclsResource(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribeAclsResource(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public DescribeAclsResource(JsonNode _node, short _version) {
            this.fromJson(_node, _version);
        }

        public DescribeAclsResource() {
            this.resourceType = 0;
            this.resourceName = "";
            this.patternType = (byte)3;
            this.acls = new ArrayList<AclDescription>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<AclDescription> newCollection;
            int arrayLength;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeAclsResource");
            }
            this.resourceType = _readable.readByte();
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field resourceName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field resourceName had invalid length " + length);
            }
            this.resourceName = _readable.readString(length);
            this.patternType = _version >= 1 ? _readable.readByte() : (byte)3;
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field acls was serialized as null");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new AclDescription(_readable, _version));
                }
                this.acls = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field acls was serialized as null");
                }
                newCollection = new ArrayList<AclDescription>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new AclDescription(_readable, _version));
                }
                this.acls = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeByte(this.resourceType);
            Object _stringBytes = _cache.getSerializedValue(this.resourceName);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 1) {
                _writable.writeByte(this.patternType);
            } else if (this.patternType != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default patternType at version " + _version);
            }
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.acls.size() + 1);
                _stringBytes = this.acls.iterator();
                while (_stringBytes.hasNext()) {
                    AclDescription aclsElement = (AclDescription)_stringBytes.next();
                    aclsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.acls.size());
                _stringBytes = this.acls.iterator();
                while (_stringBytes.hasNext()) {
                    AclDescription aclsElement = (AclDescription)_stringBytes.next();
                    aclsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeAclsResource");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.resourceType = struct.getByte("resource_type");
            this.resourceName = struct.getString("resource_name");
            this.patternType = _version >= 1 ? struct.getByte("pattern_type") : (byte)3;
            Object[] _nestedObjects = struct.getArray("acls");
            this.acls = new ArrayList<AclDescription>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.acls.add(new AclDescription((Struct)nestedObject, _version));
            }
            if (_version >= 2 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribeAclsResource");
            }
            TreeMap _taggedFields = null;
            if (_version >= 2) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("resource_type", (Object)this.resourceType);
            struct.set("resource_name", (Object)this.resourceName);
            if (_version >= 1) {
                struct.set("pattern_type", (Object)this.patternType);
            } else if (this.patternType != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default patternType at version " + _version);
            }
            Struct[] _nestedObjects = new Struct[this.acls.size()];
            int i = 0;
            for (AclDescription element : this.acls) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("acls", (Object)_nestedObjects);
            if (_version >= 2) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public void fromJson(JsonNode _node, short _version) {
            JsonNode _resourceTypeNode = _node.get("resourceType");
            if (_resourceTypeNode == null) {
                throw new RuntimeException("DescribeAclsResource: unable to locate field 'resourceType', which is mandatory in version " + _version);
            }
            this.resourceType = MessageUtil.jsonNodeToByte(_resourceTypeNode, "DescribeAclsResource");
            JsonNode _resourceNameNode = _node.get("resourceName");
            if (_resourceNameNode == null) {
                throw new RuntimeException("DescribeAclsResource: unable to locate field 'resourceName', which is mandatory in version " + _version);
            }
            if (!_resourceNameNode.isTextual()) {
                throw new RuntimeException("DescribeAclsResource expected a string type, but got " + _node.getNodeType());
            }
            this.resourceName = _resourceNameNode.asText();
            JsonNode _patternTypeNode = _node.get("patternType");
            if (_patternTypeNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("DescribeAclsResource: unable to locate field 'patternType', which is mandatory in version " + _version);
                }
                this.patternType = (byte)3;
            } else {
                this.patternType = MessageUtil.jsonNodeToByte(_patternTypeNode, "DescribeAclsResource");
            }
            JsonNode _aclsNode = _node.get("acls");
            if (_aclsNode == null) {
                throw new RuntimeException("DescribeAclsResource: unable to locate field 'acls', which is mandatory in version " + _version);
            }
            if (!_aclsNode.isArray()) {
                throw new RuntimeException("DescribeAclsResource expected a JSON array, but got " + _node.getNodeType());
            }
            this.acls = new ArrayList<AclDescription>();
            for (JsonNode _element : _aclsNode) {
                this.acls.add(new AclDescription(_element, _version));
            }
        }

        @Override
        public JsonNode toJson(short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("resourceType", (JsonNode)new ShortNode((short)this.resourceType));
            _node.set("resourceName", (JsonNode)new TextNode(this.resourceName));
            if (_version >= 1) {
                _node.set("patternType", (JsonNode)new ShortNode((short)this.patternType));
            } else if (this.patternType != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default patternType at version " + _version);
            }
            ArrayNode _aclsArray = new ArrayNode(JsonNodeFactory.instance);
            for (AclDescription _element : this.acls) {
                _aclsArray.add(_element.toJson(_version));
            }
            _node.set("acls", (JsonNode)_aclsArray);
            return _node;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeAclsResource");
            }
            ++_size;
            byte[] _stringBytes = this.resourceName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'resourceName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.resourceName, _stringBytes);
            _size = _version >= 2 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            if (_version >= 1) {
                ++_size;
            }
            int _arraySize = 0;
            _arraySize = _version >= 2 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.acls.size() + 1)) : (_arraySize += 4);
            for (AclDescription aclsElement : this.acls) {
                _arraySize += aclsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 2) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeAclsResource)) {
                return false;
            }
            DescribeAclsResource other = (DescribeAclsResource)obj;
            if (this.resourceType != other.resourceType) {
                return false;
            }
            if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
                return false;
            }
            if (this.patternType != other.patternType) {
                return false;
            }
            return !(this.acls == null ? other.acls != null : !this.acls.equals(other.acls));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            hashCode = 31 * hashCode + this.patternType;
            hashCode = 31 * hashCode + (this.acls == null ? 0 : this.acls.hashCode());
            return hashCode;
        }

        @Override
        public DescribeAclsResource duplicate() {
            DescribeAclsResource _duplicate = new DescribeAclsResource();
            _duplicate.resourceType = this.resourceType;
            _duplicate.resourceName = this.resourceName;
            _duplicate.patternType = this.patternType;
            ArrayList<AclDescription> newAcls = new ArrayList<AclDescription>(this.acls.size());
            for (AclDescription _element : this.acls) {
                newAcls.add(_element.duplicate());
            }
            _duplicate.acls = newAcls;
            return _duplicate;
        }

        public String toString() {
            return "DescribeAclsResource(resourceType=" + this.resourceType + ", resourceName=" + (this.resourceName == null ? "null" : "'" + this.resourceName.toString() + "'") + ", patternType=" + this.patternType + ", acls=" + MessageUtil.deepToString(this.acls.iterator()) + ")";
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public byte patternType() {
            return this.patternType;
        }

        public List<AclDescription> acls() {
            return this.acls;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeAclsResource setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public DescribeAclsResource setResourceName(String v) {
            this.resourceName = v;
            return this;
        }

        public DescribeAclsResource setPatternType(byte v) {
            this.patternType = v;
            return this;
        }

        public DescribeAclsResource setAcls(List<AclDescription> v) {
            this.acls = v;
            return this;
        }
    }
}

