/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.variables;

import java.util.concurrent.CompletableFuture;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.BaseDataVariableNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.BuildInfoNode;
import org.eclipse.milo.opcua.sdk.client.model.types.variables.ServerStatusType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ServerState;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;

public class ServerStatusNode
extends BaseDataVariableNode
implements ServerStatusType {
    public ServerStatusNode(OpcUaClient client, NodeId nodeId) {
        super(client, nodeId);
    }

    public CompletableFuture<BaseDataVariableNode> getStartTimeNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "StartTime").thenApply(BaseDataVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<DateTime> getStartTime() {
        return ((CompletableFuture)this.getStartTimeNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, DateTime.class));
    }

    @Override
    public CompletableFuture<StatusCode> setStartTime(DateTime value) {
        return this.getStartTimeNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<BaseDataVariableNode> getCurrentTimeNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "CurrentTime").thenApply(BaseDataVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<DateTime> getCurrentTime() {
        return ((CompletableFuture)this.getCurrentTimeNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, DateTime.class));
    }

    @Override
    public CompletableFuture<StatusCode> setCurrentTime(DateTime value) {
        return this.getCurrentTimeNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<BaseDataVariableNode> getStateNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "State").thenApply(BaseDataVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<ServerState> getState() {
        return ((CompletableFuture)this.getStateNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, ServerState.class));
    }

    @Override
    public CompletableFuture<StatusCode> setState(ServerState value) {
        return this.getStateNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<BuildInfoNode> getBuildInfoNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "BuildInfo").thenApply(BuildInfoNode.class::cast);
    }

    @Override
    public CompletableFuture<BuildInfo> getBuildInfo() {
        return ((CompletableFuture)this.getBuildInfoNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, BuildInfo.class));
    }

    @Override
    public CompletableFuture<StatusCode> setBuildInfo(BuildInfo value) {
        return this.getBuildInfoNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<BaseDataVariableNode> getSecondsTillShutdownNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "SecondsTillShutdown").thenApply(BaseDataVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<UInteger> getSecondsTillShutdown() {
        return ((CompletableFuture)this.getSecondsTillShutdownNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, UInteger.class));
    }

    @Override
    public CompletableFuture<StatusCode> setSecondsTillShutdown(UInteger value) {
        return this.getSecondsTillShutdownNode().thenCompose(node -> node.setValue(value));
    }

    public CompletableFuture<BaseDataVariableNode> getShutdownReasonNode() {
        return this.getVariableComponent("http://opcfoundation.org/UA/", "ShutdownReason").thenApply(BaseDataVariableNode.class::cast);
    }

    @Override
    public CompletableFuture<LocalizedText> getShutdownReason() {
        return ((CompletableFuture)this.getShutdownReasonNode().thenCompose(UaVariableNode::getValue)).thenApply(o -> this.cast(o, LocalizedText.class));
    }

    @Override
    public CompletableFuture<StatusCode> setShutdownReason(LocalizedText value) {
        return this.getShutdownReasonNode().thenCompose(node -> node.setValue(value));
    }
}

