/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public class ViewDescription
implements UaStructure {
    public static final NodeId TypeId = Identifiers.ViewDescription;
    public static final NodeId BinaryEncodingId = Identifiers.ViewDescription_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.ViewDescription_Encoding_DefaultXml;
    protected final NodeId viewId;
    protected final DateTime timestamp;
    protected final UInteger viewVersion;

    public ViewDescription() {
        this.viewId = null;
        this.timestamp = null;
        this.viewVersion = null;
    }

    public ViewDescription(NodeId viewId, DateTime timestamp, UInteger viewVersion) {
        this.viewId = viewId;
        this.timestamp = timestamp;
        this.viewVersion = viewVersion;
    }

    public NodeId getViewId() {
        return this.viewId;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public UInteger getViewVersion() {
        return this.viewVersion;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ViewId", (Object)this.viewId).add("Timestamp", (Object)this.timestamp).add("ViewVersion", (Object)this.viewVersion).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<ViewDescription> {
        @Override
        public Class<ViewDescription> getType() {
            return ViewDescription.class;
        }

        @Override
        public ViewDescription decode(UaDecoder decoder) throws UaSerializationException {
            NodeId viewId = decoder.readNodeId("ViewId");
            DateTime timestamp = decoder.readDateTime("Timestamp");
            UInteger viewVersion = decoder.readUInt32("ViewVersion");
            return new ViewDescription(viewId, timestamp, viewVersion);
        }

        @Override
        public void encode(ViewDescription value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeNodeId("ViewId", value.viewId);
            encoder.writeDateTime("Timestamp", value.timestamp);
            encoder.writeUInt32("ViewVersion", value.viewVersion);
        }
    }
}

