/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ComplianceLevel;

public class SupportedProfile
implements UaStructure {
    public static final NodeId TypeId = Identifiers.SupportedProfile;
    public static final NodeId BinaryEncodingId = Identifiers.SupportedProfile_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.SupportedProfile_Encoding_DefaultXml;
    protected final String organizationUri;
    protected final String profileId;
    protected final String complianceTool;
    protected final DateTime complianceDate;
    protected final ComplianceLevel complianceLevel;
    protected final String[] unsupportedUnitIds;

    public SupportedProfile() {
        this.organizationUri = null;
        this.profileId = null;
        this.complianceTool = null;
        this.complianceDate = null;
        this.complianceLevel = null;
        this.unsupportedUnitIds = null;
    }

    public SupportedProfile(String organizationUri, String profileId, String complianceTool, DateTime complianceDate, ComplianceLevel complianceLevel, String[] unsupportedUnitIds) {
        this.organizationUri = organizationUri;
        this.profileId = profileId;
        this.complianceTool = complianceTool;
        this.complianceDate = complianceDate;
        this.complianceLevel = complianceLevel;
        this.unsupportedUnitIds = unsupportedUnitIds;
    }

    public String getOrganizationUri() {
        return this.organizationUri;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getComplianceTool() {
        return this.complianceTool;
    }

    public DateTime getComplianceDate() {
        return this.complianceDate;
    }

    public ComplianceLevel getComplianceLevel() {
        return this.complianceLevel;
    }

    @Nullable
    public String[] getUnsupportedUnitIds() {
        return this.unsupportedUnitIds;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("OrganizationUri", (Object)this.organizationUri).add("ProfileId", (Object)this.profileId).add("ComplianceTool", (Object)this.complianceTool).add("ComplianceDate", (Object)this.complianceDate).add("ComplianceLevel", (Object)this.complianceLevel).add("UnsupportedUnitIds", (Object)this.unsupportedUnitIds).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<SupportedProfile> {
        @Override
        public Class<SupportedProfile> getType() {
            return SupportedProfile.class;
        }

        @Override
        public SupportedProfile decode(UaDecoder decoder) throws UaSerializationException {
            String organizationUri = decoder.readString("OrganizationUri");
            String profileId = decoder.readString("ProfileId");
            String complianceTool = decoder.readString("ComplianceTool");
            DateTime complianceDate = decoder.readDateTime("ComplianceDate");
            ComplianceLevel complianceLevel = ComplianceLevel.from(decoder.readInt32("ComplianceLevel"));
            String[] unsupportedUnitIds = decoder.readArray("UnsupportedUnitIds", decoder::readString, String.class);
            return new SupportedProfile(organizationUri, profileId, complianceTool, complianceDate, complianceLevel, unsupportedUnitIds);
        }

        @Override
        public void encode(SupportedProfile value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeString("OrganizationUri", value.organizationUri);
            encoder.writeString("ProfileId", value.profileId);
            encoder.writeString("ComplianceTool", value.complianceTool);
            encoder.writeDateTime("ComplianceDate", value.complianceDate);
            encoder.writeInt32("ComplianceLevel", value.complianceLevel != null ? value.complianceLevel.getValue() : 0);
            encoder.writeArray("UnsupportedUnitIds", value.unsupportedUnitIds, encoder::writeString);
        }
    }
}

