/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePathElement;

public class RelativePath
implements UaStructure {
    public static final NodeId TypeId = Identifiers.RelativePath;
    public static final NodeId BinaryEncodingId = Identifiers.RelativePath_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.RelativePath_Encoding_DefaultXml;
    protected final RelativePathElement[] elements;

    public RelativePath() {
        this.elements = null;
    }

    public RelativePath(RelativePathElement[] elements) {
        this.elements = elements;
    }

    @Nullable
    public RelativePathElement[] getElements() {
        return this.elements;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Elements", (Object)this.elements).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<RelativePath> {
        @Override
        public Class<RelativePath> getType() {
            return RelativePath.class;
        }

        @Override
        public RelativePath decode(UaDecoder decoder) throws UaSerializationException {
            RelativePathElement[] elements = (RelativePathElement[])decoder.readBuiltinStructArray("Elements", RelativePathElement.class);
            return new RelativePath(elements);
        }

        @Override
        public void encode(RelativePath value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStructArray("Elements", value.elements, RelativePathElement.class);
        }
    }
}

