/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import com.google.common.collect.ImmutableMap;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;

public enum ApplicationType implements UaEnumeration
{
    Server(0),
    Client(1),
    ClientAndServer(2),
    DiscoveryServer(3);

    private final int value;
    private static final ImmutableMap<Integer, ApplicationType> VALUES;

    private ApplicationType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static ApplicationType from(Integer value) {
        if (value == null) {
            return null;
        }
        return (ApplicationType)VALUES.getOrDefault((Object)value, null);
    }

    public static void encode(ApplicationType applicationType, UaEncoder encoder) {
        encoder.writeInt32(null, applicationType.getValue());
    }

    public static ApplicationType decode(UaDecoder decoder) {
        int value = decoder.readInt32(null);
        return (ApplicationType)VALUES.getOrDefault((Object)value, null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ApplicationType e : ApplicationType.values()) {
            builder.put((Object)e.getValue(), (Object)e);
        }
        VALUES = builder.build();
    }
}

