/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.OpcUaXmlDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultXmlEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;

public class OpcUaXmlDataTypeDictionary
implements DataTypeDictionary<OpcUaXmlDataTypeCodec<?>> {
    private final String namespaceUri;
    private final Map<String, OpcUaXmlDataTypeCodec<?>> codecsByDescription;
    private final Map<NodeId, OpcUaXmlDataTypeCodec<?>> codecsByEncodingId;
    private final Map<NodeId, OpcUaXmlDataTypeCodec<?>> codecsByDataTypeId;

    public OpcUaXmlDataTypeDictionary(String namespaceUri) {
        this.namespaceUri = namespaceUri;
        this.codecsByDescription = Maps.newConcurrentMap();
        this.codecsByEncodingId = Maps.newConcurrentMap();
        this.codecsByDataTypeId = Maps.newConcurrentMap();
    }

    public OpcUaXmlDataTypeDictionary(String namespaceUri, Map<String, OpcUaXmlDataTypeCodec<?>> byDescription, Map<NodeId, OpcUaXmlDataTypeCodec<?>> byEncodingId, Map<NodeId, OpcUaXmlDataTypeCodec<?>> byDataTypeId) {
        this.namespaceUri = namespaceUri;
        this.codecsByDescription = Maps.newConcurrentMap();
        this.codecsByDescription.putAll(byDescription);
        this.codecsByEncodingId = Maps.newConcurrentMap();
        this.codecsByEncodingId.putAll(byEncodingId);
        this.codecsByDataTypeId = Maps.newConcurrentMap();
        this.codecsByDataTypeId.putAll(byDataTypeId);
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public QualifiedName getEncodingName() {
        return OpcUaDefaultXmlEncoding.ENCODING_NAME;
    }

    @Override
    public OpcUaXmlDataTypeCodec<?> getCodec(String description) {
        return this.codecsByDescription.get(description);
    }

    @Override
    public OpcUaXmlDataTypeCodec<?> getCodec(NodeId dataTypeId) {
        return this.codecsByDataTypeId.get(dataTypeId);
    }

    @Override
    public void registerEnumCodec(OpcUaXmlDataTypeCodec<?> codec, String description) {
        this.codecsByDescription.put(description, codec);
    }

    @Override
    public void registerStructCodec(OpcUaXmlDataTypeCodec<?> codec, String description, NodeId dataTypeId, NodeId encodingId) {
        this.codecsByDescription.put(description, codec);
        this.codecsByDataTypeId.put(dataTypeId, codec);
        this.codecsByEncodingId.put(encodingId, codec);
    }

    @Override
    public Map<String, OpcUaXmlDataTypeCodec<?>> getCodecsByDescription() {
        return this.codecsByDescription;
    }

    @Override
    public Map<NodeId, OpcUaXmlDataTypeCodec<?>> getCodecsByEncodingId() {
        return this.codecsByEncodingId;
    }

    @Override
    public Map<NodeId, OpcUaXmlDataTypeCodec<?>> getCodecsByDataTypeId() {
        return this.codecsByDataTypeId;
    }
}

