/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.services;

import java.util.List;
import org.eclipse.milo.opcua.sdk.server.DiagnosticsContext;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.Session;
import org.eclipse.milo.opcua.sdk.server.api.services.AttributeServices;
import org.eclipse.milo.opcua.sdk.server.services.ServiceAttributes;
import org.eclipse.milo.opcua.sdk.server.services.ServiceCounter;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.server.services.AttributeServiceSet;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;

public class DefaultAttributeServiceSet
implements AttributeServiceSet {
    private final ServiceCounter readMetric = new ServiceCounter();
    private final ServiceCounter writeMetric = new ServiceCounter();

    public void onRead(ServiceRequest service) {
        this.readMetric.record(service);
        ReadRequest request = (ReadRequest)service.getRequest();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        List nodesToRead = ConversionUtil.l((Object[])request.getNodesToRead());
        if (nodesToRead.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if ((long)nodesToRead.size() > server.getConfig().getLimits().getMaxNodesPerRead().longValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        if (request.getMaxAge() < 0.0) {
            service.setServiceFault(0x80700000L);
            return;
        }
        if (request.getTimestampsToReturn() == null) {
            service.setServiceFault(2150301696L);
            return;
        }
        DiagnosticsContext<ReadValueId> diagnosticsContext = new DiagnosticsContext<ReadValueId>();
        AttributeServices.ReadContext context = new AttributeServices.ReadContext(server, session, diagnosticsContext);
        server.getAddressSpaceManager().read(context, request.getMaxAge(), request.getTimestampsToReturn(), nodesToRead);
        context.getFuture().thenAccept(values -> {
            ResponseHeader header = service.createResponseHeader();
            DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToRead);
            ReadResponse response = new ReadResponse(header, values.toArray(new DataValue[0]), diagnosticInfos);
            service.setResponse((UaResponseMessage)response);
        });
    }

    public void onWrite(ServiceRequest service) {
        this.writeMetric.record(service);
        WriteRequest request = (WriteRequest)service.getRequest();
        OpcUaServer server = (OpcUaServer)service.attr(ServiceAttributes.SERVER_KEY).get();
        Session session = (Session)service.attr(ServiceAttributes.SESSION_KEY).get();
        List nodesToWrite = ConversionUtil.l((Object[])request.getNodesToWrite());
        if (nodesToWrite.isEmpty()) {
            service.setServiceFault(0x800F0000L);
            return;
        }
        if (nodesToWrite.size() > server.getConfig().getLimits().getMaxNodesPerWrite().intValue()) {
            service.setServiceFault(0x80100000L);
            return;
        }
        DiagnosticsContext diagnosticsContext = new DiagnosticsContext();
        AttributeServices.WriteContext context = new AttributeServices.WriteContext(server, session, new DiagnosticsContext<WriteValue>());
        server.getAddressSpaceManager().write(context, nodesToWrite);
        context.getFuture().thenAccept(values -> {
            ResponseHeader header = service.createResponseHeader();
            DiagnosticInfo[] diagnosticInfos = diagnosticsContext.getDiagnosticInfos(nodesToWrite);
            WriteResponse response = new WriteResponse(header, values.toArray(new StatusCode[0]), diagnosticInfos);
            service.setResponse((UaResponseMessage)response);
        });
    }
}

