/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class FindServersOnNetworkRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.FindServersOnNetworkRequest;
    public static final NodeId BinaryEncodingId = Identifiers.FindServersOnNetworkRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.FindServersOnNetworkRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final UInteger startingRecordId;
    protected final UInteger maxRecordsToReturn;
    protected final String[] serverCapabilityFilter;

    public FindServersOnNetworkRequest() {
        this.requestHeader = null;
        this.startingRecordId = null;
        this.maxRecordsToReturn = null;
        this.serverCapabilityFilter = null;
    }

    public FindServersOnNetworkRequest(RequestHeader requestHeader, UInteger startingRecordId, UInteger maxRecordsToReturn, String[] serverCapabilityFilter) {
        this.requestHeader = requestHeader;
        this.startingRecordId = startingRecordId;
        this.maxRecordsToReturn = maxRecordsToReturn;
        this.serverCapabilityFilter = serverCapabilityFilter;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getStartingRecordId() {
        return this.startingRecordId;
    }

    public UInteger getMaxRecordsToReturn() {
        return this.maxRecordsToReturn;
    }

    @Nullable
    public String[] getServerCapabilityFilter() {
        return this.serverCapabilityFilter;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("StartingRecordId", (Object)this.startingRecordId).add("MaxRecordsToReturn", (Object)this.maxRecordsToReturn).add("ServerCapabilityFilter", (Object)this.serverCapabilityFilter).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<FindServersOnNetworkRequest> {
        @Override
        public Class<FindServersOnNetworkRequest> getType() {
            return FindServersOnNetworkRequest.class;
        }

        @Override
        public FindServersOnNetworkRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            UInteger startingRecordId = decoder.readUInt32("StartingRecordId");
            UInteger maxRecordsToReturn = decoder.readUInt32("MaxRecordsToReturn");
            String[] serverCapabilityFilter = decoder.readArray("ServerCapabilityFilter", decoder::readString, String.class);
            return new FindServersOnNetworkRequest(requestHeader, startingRecordId, maxRecordsToReturn, serverCapabilityFilter);
        }

        @Override
        public void encode(FindServersOnNetworkRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeUInt32("StartingRecordId", value.startingRecordId);
            encoder.writeUInt32("MaxRecordsToReturn", value.maxRecordsToReturn);
            encoder.writeArray("ServerCapabilityFilter", value.serverCapabilityFilter, encoder::writeString);
        }
    }
}

