/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFieldList;
import org.eclipse.milo.opcua.stack.core.types.structured.NotificationData;

public class EventNotificationList
extends NotificationData {
    public static final NodeId TypeId = Identifiers.EventNotificationList;
    public static final NodeId BinaryEncodingId = Identifiers.EventNotificationList_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.EventNotificationList_Encoding_DefaultXml;
    protected final EventFieldList[] events;

    public EventNotificationList() {
        this.events = null;
    }

    public EventNotificationList(EventFieldList[] events) {
        this.events = events;
    }

    @Nullable
    public EventFieldList[] getEvents() {
        return this.events;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Events", (Object)this.events).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<EventNotificationList> {
        @Override
        public Class<EventNotificationList> getType() {
            return EventNotificationList.class;
        }

        @Override
        public EventNotificationList decode(UaDecoder decoder) throws UaSerializationException {
            EventFieldList[] events = (EventFieldList[])decoder.readBuiltinStructArray("Events", EventFieldList.class);
            return new EventNotificationList(events);
        }

        @Override
        public void encode(EventNotificationList value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStructArray("Events", value.events, EventFieldList.class);
        }
    }
}

