/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.SimpleAttributeOperand;

public class EventFilter
extends MonitoringFilter {
    public static final NodeId TypeId = Identifiers.EventFilter;
    public static final NodeId BinaryEncodingId = Identifiers.EventFilter_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.EventFilter_Encoding_DefaultXml;
    protected final SimpleAttributeOperand[] selectClauses;
    protected final ContentFilter whereClause;

    public EventFilter() {
        this.selectClauses = null;
        this.whereClause = null;
    }

    public EventFilter(SimpleAttributeOperand[] selectClauses, ContentFilter whereClause) {
        this.selectClauses = selectClauses;
        this.whereClause = whereClause;
    }

    @Nullable
    public SimpleAttributeOperand[] getSelectClauses() {
        return this.selectClauses;
    }

    public ContentFilter getWhereClause() {
        return this.whereClause;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("SelectClauses", (Object)this.selectClauses).add("WhereClause", (Object)this.whereClause).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<EventFilter> {
        @Override
        public Class<EventFilter> getType() {
            return EventFilter.class;
        }

        @Override
        public EventFilter decode(UaDecoder decoder) throws UaSerializationException {
            SimpleAttributeOperand[] selectClauses = (SimpleAttributeOperand[])decoder.readBuiltinStructArray("SelectClauses", SimpleAttributeOperand.class);
            ContentFilter whereClause = decoder.readBuiltinStruct("WhereClause", ContentFilter.class);
            return new EventFilter(selectClauses, whereClause);
        }

        @Override
        public void encode(EventFilter value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStructArray("SelectClauses", value.selectClauses, SimpleAttributeOperand.class);
            encoder.writeBuiltinStruct("WhereClause", value.whereClause, ContentFilter.class);
        }
    }
}

