/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class CreateSubscriptionRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.CreateSubscriptionRequest;
    public static final NodeId BinaryEncodingId = Identifiers.CreateSubscriptionRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.CreateSubscriptionRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final Double requestedPublishingInterval;
    protected final UInteger requestedLifetimeCount;
    protected final UInteger requestedMaxKeepAliveCount;
    protected final UInteger maxNotificationsPerPublish;
    protected final Boolean publishingEnabled;
    protected final UByte priority;

    public CreateSubscriptionRequest() {
        this.requestHeader = null;
        this.requestedPublishingInterval = null;
        this.requestedLifetimeCount = null;
        this.requestedMaxKeepAliveCount = null;
        this.maxNotificationsPerPublish = null;
        this.publishingEnabled = null;
        this.priority = null;
    }

    public CreateSubscriptionRequest(RequestHeader requestHeader, Double requestedPublishingInterval, UInteger requestedLifetimeCount, UInteger requestedMaxKeepAliveCount, UInteger maxNotificationsPerPublish, Boolean publishingEnabled, UByte priority) {
        this.requestHeader = requestHeader;
        this.requestedPublishingInterval = requestedPublishingInterval;
        this.requestedLifetimeCount = requestedLifetimeCount;
        this.requestedMaxKeepAliveCount = requestedMaxKeepAliveCount;
        this.maxNotificationsPerPublish = maxNotificationsPerPublish;
        this.publishingEnabled = publishingEnabled;
        this.priority = priority;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public Double getRequestedPublishingInterval() {
        return this.requestedPublishingInterval;
    }

    public UInteger getRequestedLifetimeCount() {
        return this.requestedLifetimeCount;
    }

    public UInteger getRequestedMaxKeepAliveCount() {
        return this.requestedMaxKeepAliveCount;
    }

    public UInteger getMaxNotificationsPerPublish() {
        return this.maxNotificationsPerPublish;
    }

    public Boolean getPublishingEnabled() {
        return this.publishingEnabled;
    }

    public UByte getPriority() {
        return this.priority;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("RequestedPublishingInterval", (Object)this.requestedPublishingInterval).add("RequestedLifetimeCount", (Object)this.requestedLifetimeCount).add("RequestedMaxKeepAliveCount", (Object)this.requestedMaxKeepAliveCount).add("MaxNotificationsPerPublish", (Object)this.maxNotificationsPerPublish).add("PublishingEnabled", (Object)this.publishingEnabled).add("Priority", (Object)this.priority).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<CreateSubscriptionRequest> {
        @Override
        public Class<CreateSubscriptionRequest> getType() {
            return CreateSubscriptionRequest.class;
        }

        @Override
        public CreateSubscriptionRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            Double requestedPublishingInterval = decoder.readDouble("RequestedPublishingInterval");
            UInteger requestedLifetimeCount = decoder.readUInt32("RequestedLifetimeCount");
            UInteger requestedMaxKeepAliveCount = decoder.readUInt32("RequestedMaxKeepAliveCount");
            UInteger maxNotificationsPerPublish = decoder.readUInt32("MaxNotificationsPerPublish");
            Boolean publishingEnabled = decoder.readBoolean("PublishingEnabled");
            UByte priority = decoder.readByte("Priority");
            return new CreateSubscriptionRequest(requestHeader, requestedPublishingInterval, requestedLifetimeCount, requestedMaxKeepAliveCount, maxNotificationsPerPublish, publishingEnabled, priority);
        }

        @Override
        public void encode(CreateSubscriptionRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeDouble("RequestedPublishingInterval", value.requestedPublishingInterval);
            encoder.writeUInt32("RequestedLifetimeCount", value.requestedLifetimeCount);
            encoder.writeUInt32("RequestedMaxKeepAliveCount", value.requestedMaxKeepAliveCount);
            encoder.writeUInt32("MaxNotificationsPerPublish", value.maxNotificationsPerPublish);
            encoder.writeBoolean("PublishingEnabled", value.publishingEnabled);
            encoder.writeByte("Priority", value.priority);
        }
    }
}

