/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesItem;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class AddNodesRequest
implements UaRequestMessage {
    public static final NodeId TypeId = Identifiers.AddNodesRequest;
    public static final NodeId BinaryEncodingId = Identifiers.AddNodesRequest_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.AddNodesRequest_Encoding_DefaultXml;
    protected final RequestHeader requestHeader;
    protected final AddNodesItem[] nodesToAdd;

    public AddNodesRequest() {
        this.requestHeader = null;
        this.nodesToAdd = null;
    }

    public AddNodesRequest(RequestHeader requestHeader, AddNodesItem[] nodesToAdd) {
        this.requestHeader = requestHeader;
        this.nodesToAdd = nodesToAdd;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    @Nullable
    public AddNodesItem[] getNodesToAdd() {
        return this.nodesToAdd;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("RequestHeader", (Object)this.requestHeader).add("NodesToAdd", (Object)this.nodesToAdd).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<AddNodesRequest> {
        @Override
        public Class<AddNodesRequest> getType() {
            return AddNodesRequest.class;
        }

        @Override
        public AddNodesRequest decode(UaDecoder decoder) throws UaSerializationException {
            RequestHeader requestHeader = decoder.readBuiltinStruct("RequestHeader", RequestHeader.class);
            AddNodesItem[] nodesToAdd = (AddNodesItem[])decoder.readBuiltinStructArray("NodesToAdd", AddNodesItem.class);
            return new AddNodesRequest(requestHeader, nodesToAdd);
        }

        @Override
        public void encode(AddNodesRequest value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("RequestHeader", value.requestHeader, RequestHeader.class);
            encoder.writeBuiltinStructArray("NodesToAdd", value.nodesToAdd, AddNodesItem.class);
        }
    }
}

