/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.BuiltinDataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.DataTypeDictionary;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;

public class OpcUaDataTypeManager
implements DataTypeManager {
    public static final String BINARY_NAMESPACE_URI = "http://opcfoundation.org/UA/";
    public static final String XML_NAMESPACE_URI = "http://opcfoundation.org/UA/2008/02/Types.xsd";
    private final ConcurrentMap<String, DataTypeDictionary<?>> dictionaries = Maps.newConcurrentMap();
    private final ConcurrentMap<NodeId, DataTypeCodec> codecsByEncodingId = Maps.newConcurrentMap();
    private final Table<QualifiedName, NodeId, DataTypeCodec> codecsByDataTypeId = Tables.synchronizedTable((Table)HashBasedTable.create());

    public static OpcUaDataTypeManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private OpcUaDataTypeManager() {
        this.registerTypeDictionary(BuiltinDataTypeDictionary.getBinaryInstance());
        this.registerTypeDictionary(BuiltinDataTypeDictionary.getXmlInstance());
    }

    @Override
    public void registerCodec(NodeId encodingId, DataTypeCodec codec) {
        this.codecsByEncodingId.put(encodingId, codec);
    }

    @Override
    public void registerCodec(QualifiedName encodingName, NodeId dataTypeId, DataTypeCodec codec) {
        this.codecsByDataTypeId.put((Object)encodingName, (Object)dataTypeId, (Object)codec);
    }

    @Override
    public void registerTypeDictionary(DataTypeDictionary<?> dataTypeDictionary) {
        this.dictionaries.put(dataTypeDictionary.getNamespaceUri(), dataTypeDictionary);
        this.codecsByEncodingId.putAll(dataTypeDictionary.getCodecsByEncodingId());
        dataTypeDictionary.getCodecsByDataTypeId().forEach((dataTypeId, codec) -> {
            DataTypeCodec cfr_ignored_0 = (DataTypeCodec)this.codecsByDataTypeId.put((Object)dataTypeDictionary.getEncodingName(), dataTypeId, codec);
        });
    }

    @Override
    @Nullable
    public DataTypeCodec getCodec(NodeId encodingId) {
        return (DataTypeCodec)this.codecsByEncodingId.get(encodingId);
    }

    @Override
    @Nullable
    public DataTypeCodec getCodec(QualifiedName encodingName, NodeId dataTypeId) {
        return (DataTypeCodec)this.codecsByDataTypeId.get((Object)encodingName, (Object)dataTypeId);
    }

    @Override
    @Nullable
    public DataTypeCodec getCodec(String namespaceUri, String description) {
        DataTypeDictionary dataTypeDictionary = (DataTypeDictionary)this.dictionaries.get(namespaceUri);
        return dataTypeDictionary != null ? (DataTypeCodec)dataTypeDictionary.getCodec(description) : null;
    }

    private static class InstanceHolder {
        private static final OpcUaDataTypeManager INSTANCE = new OpcUaDataTypeManager();

        private InstanceHolder() {
        }
    }
}

