/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.security;

import java.security.cert.X509Certificate;
import java.util.List;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.TrustListManager;
import org.eclipse.milo.opcua.stack.core.util.CertificateValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCertificateValidator
implements CertificateValidator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TrustListManager trustListManager;

    public DefaultCertificateValidator(TrustListManager trustListManager) {
        this.trustListManager = trustListManager;
    }

    @Override
    public synchronized void validate(X509Certificate certificate) throws UaException {
        try {
            CertificateValidationUtil.validateCertificateValidity(certificate);
        }
        catch (UaException e) {
            this.logger.debug("validation failed: {}", (Object)certificate.getSubjectX500Principal());
            this.trustListManager.addRejectedCertificate(certificate);
            throw e;
        }
    }

    @Override
    public synchronized void verifyTrustChain(List<X509Certificate> certificateChain) throws UaException {
        try {
            CertificateValidationUtil.verifyTrustChain(certificateChain, this.trustListManager.getTrustedCertificates(), this.trustListManager.getTrustedCrls(), this.trustListManager.getIssuerCertificates(), this.trustListManager.getIssuerCrls());
        }
        catch (UaException e) {
            X509Certificate certificate = certificateChain.get(0);
            this.logger.debug("verification failed: {}", (Object)certificate.getSubjectX500Principal());
            certificateChain.forEach(this.trustListManager::addRejectedCertificate);
            throw e;
        }
    }
}

