/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel.headers;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;

public class AsymmetricSecurityHeader {
    private final String securityPolicyUri;
    private final ByteString senderCertificate;
    private final ByteString receiverThumbprint;

    public AsymmetricSecurityHeader(@Nonnull String securityPolicyUri, @Nonnull ByteString senderCertificate, @Nonnull ByteString receiverThumbprint) {
        Preconditions.checkNotNull((Object)securityPolicyUri);
        Preconditions.checkArgument((securityPolicyUri.getBytes(Charset.forName("UTF-8")).length <= 255 ? 1 : 0) != 0, (Object)"securityPolicyUri length cannot be greater than 255 bytes");
        Preconditions.checkArgument((receiverThumbprint.bytes() == null || receiverThumbprint.length() == 20 ? 1 : 0) != 0, (Object)"receiverThumbprint length must be either null or exactly 20 bytes");
        this.securityPolicyUri = securityPolicyUri;
        this.senderCertificate = senderCertificate;
        this.receiverThumbprint = receiverThumbprint;
    }

    @Nonnull
    public String getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    @Nonnull
    public ByteString getSenderCertificate() {
        return this.senderCertificate;
    }

    @Nonnull
    public ByteString getReceiverThumbprint() {
        return this.receiverThumbprint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsymmetricSecurityHeader that = (AsymmetricSecurityHeader)o;
        return this.receiverThumbprint.equals(that.receiverThumbprint) && this.securityPolicyUri.equals(that.securityPolicyUri) && this.senderCertificate.equals(that.senderCertificate);
    }

    public int hashCode() {
        int result = this.securityPolicyUri.hashCode();
        result = 31 * result + this.senderCertificate.hashCode();
        result = 31 * result + this.receiverThumbprint.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("securityPolicyUri", (Object)this.securityPolicyUri).add("senderCertificate", (Object)this.senderCertificate).add("receiverThumbprint", (Object)this.receiverThumbprint).toString();
    }

    public static void encode(AsymmetricSecurityHeader header, ByteBuf buffer) {
        String securityPolicy = header.getSecurityPolicyUri();
        buffer.writeIntLE(securityPolicy.length());
        buffer.writeBytes(securityPolicy.getBytes(Charset.forName("UTF-8")));
        ByteString senderCertificate = header.getSenderCertificate();
        if (senderCertificate.isNull()) {
            buffer.writeIntLE(-1);
        } else {
            buffer.writeIntLE(senderCertificate.length());
            buffer.writeBytes(senderCertificate.bytes());
        }
        ByteString receiverThumbprint = header.getReceiverThumbprint();
        if (receiverThumbprint.isNull()) {
            buffer.writeIntLE(-1);
        } else {
            buffer.writeIntLE(receiverThumbprint.length());
            buffer.writeBytes(receiverThumbprint.bytes());
        }
    }

    public static AsymmetricSecurityHeader decode(ByteBuf buffer, int maxArrayLength, int maxStringLength) {
        int thumbprintLength;
        int securityPolicyUriLength = buffer.readIntLE();
        if (securityPolicyUriLength > maxStringLength) {
            throw new UaSerializationException(0x80080000L, "max array length exceeded");
        }
        byte[] securityPolicyUriBytes = new byte[securityPolicyUriLength];
        buffer.readBytes(securityPolicyUriBytes);
        String securityPolicyUri = new String(securityPolicyUriBytes, Charset.forName("UTF-8"));
        int senderCertificateLength = buffer.readIntLE();
        if (senderCertificateLength > maxArrayLength) {
            throw new UaSerializationException(0x80080000L, "max array length exceeded");
        }
        byte[] senderCertificate = null;
        if (senderCertificateLength >= 0) {
            senderCertificate = new byte[senderCertificateLength];
            buffer.readBytes(senderCertificate);
        }
        if ((thumbprintLength = buffer.readIntLE()) > maxArrayLength) {
            throw new UaSerializationException(0x80080000L, "max array length exceeded");
        }
        byte[] receiverCertificateThumbprint = null;
        if (thumbprintLength >= 0) {
            receiverCertificateThumbprint = new byte[thumbprintLength];
            buffer.readBytes(receiverCertificateThumbprint);
        }
        return new AsymmetricSecurityHeader(securityPolicyUri, new ByteString(senderCertificate), new ByteString(receiverCertificateThumbprint));
    }
}

