/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel;

import java.util.concurrent.ExecutorService;
import org.eclipse.milo.opcua.stack.core.channel.ChannelParameters;
import org.eclipse.milo.opcua.stack.core.channel.ChunkDecoder;
import org.eclipse.milo.opcua.stack.core.channel.ChunkEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.util.ExecutionQueue;

public class SerializationQueue {
    private final OpcUaBinaryStreamEncoder binaryEncoder;
    private final OpcUaBinaryStreamDecoder binaryDecoder;
    private final ChunkEncoder chunkEncoder;
    private final ChunkDecoder chunkDecoder;
    private final ExecutionQueue encodingQueue;
    private final ExecutionQueue decodingQueue;
    private final ChannelParameters parameters;

    public SerializationQueue(ExecutorService executor, ChannelParameters parameters, SerializationContext context) {
        this.parameters = parameters;
        this.chunkEncoder = new ChunkEncoder(parameters);
        this.chunkDecoder = new ChunkDecoder(parameters, context.getEncodingLimits().getMaxArrayLength(), context.getEncodingLimits().getMaxStringLength());
        this.binaryEncoder = new OpcUaBinaryStreamEncoder(context);
        this.binaryDecoder = new OpcUaBinaryStreamDecoder(context);
        this.encodingQueue = new ExecutionQueue(executor);
        this.decodingQueue = new ExecutionQueue(executor);
    }

    public void encode(Encoder encoder) {
        this.encodingQueue.submit(() -> encoder.encode(this.binaryEncoder, this.chunkEncoder));
    }

    public void decode(Decoder decoder) {
        this.decodingQueue.submit(() -> decoder.decode(this.binaryDecoder, this.chunkDecoder));
    }

    public void pause() {
        this.encodingQueue.pause();
        this.decodingQueue.pause();
    }

    public ChannelParameters getParameters() {
        return this.parameters;
    }

    @FunctionalInterface
    public static interface Encoder {
        public void encode(OpcUaBinaryStreamEncoder var1, ChunkEncoder var2);
    }

    @FunctionalInterface
    public static interface Decoder {
        public void decode(OpcUaBinaryStreamDecoder var1, ChunkDecoder var2);
    }
}

