/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel;

import com.google.common.base.Preconditions;

public class MessageLimits {
    public static final MessageLimits DEFAULT = new MessageLimits();
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0x200000;
    public static final int DEFAULT_MAX_CHUNK_SIZE = 65535;
    public static final int DEFAULT_MAX_CHUNK_COUNT = 64;
    private final int maxChunkSize;
    private final int maxChunkCount;
    private final int maxMessageSize;

    public MessageLimits() {
        this(65535, 64, 0x200000);
    }

    public MessageLimits(int maxChunkSize, int maxChunkCount, int maxMessageSize) {
        Preconditions.checkArgument((maxChunkSize >= 8196 ? 1 : 0) != 0, (Object)"maxChunkSize must be greater than or equal to 8196");
        this.maxChunkSize = maxChunkSize;
        this.maxChunkCount = maxChunkCount;
        this.maxMessageSize = maxMessageSize;
    }

    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public int getMaxChunkCount() {
        return this.maxChunkCount;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }
}

