/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;

public class NamespaceTable {
    private final BiMap<UShort, String> uriTable = HashBiMap.create();

    public NamespaceTable() {
        this.uriTable.put((Object)Unsigned.ushort(0), (Object)"http://opcfoundation.org/UA/");
    }

    public synchronized UShort addUri(String uri) {
        if (this.uriTable.containsValue((Object)uri)) {
            return (UShort)this.uriTable.inverse().get((Object)uri);
        }
        UShort index = Unsigned.ushort(1);
        while (this.uriTable.containsKey((Object)index)) {
            if ((index = Unsigned.ushort(index.intValue() + 1)).intValue() != 65535) continue;
            throw new UaRuntimeException(0x80020000L, "uri table full");
        }
        this.uriTable.put((Object)index, (Object)uri);
        return index;
    }

    public synchronized void putUri(String uri, UShort index) {
        this.uriTable.put((Object)index, (Object)uri);
    }

    public synchronized String getUri(int index) {
        return this.getUri(Unsigned.ushort(index));
    }

    public synchronized String getUri(UShort index) {
        return (String)this.uriTable.get((Object)index);
    }

    @Nullable
    public synchronized UShort getIndex(String uri) {
        return (UShort)this.uriTable.inverse().getOrDefault((Object)uri, null);
    }

    public synchronized void update(Consumer<BiMap<UShort, String>> uriTableConsumer) {
        uriTableConsumer.accept(this.uriTable);
    }

    public synchronized String[] toArray() {
        return (String[])this.uriTable.entrySet().stream().sorted(Comparator.comparingInt(e -> ((UShort)e.getKey()).intValue())).map(Map.Entry::getValue).toArray(String[]::new);
    }
}

