/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.core;

import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.milo.opcua.stack.core.BuiltinReferenceType;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.ReferenceType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.slf4j.LoggerFactory;

public class Reference {
    private final NodeId sourceNodeId;
    private final NodeId referenceTypeId;
    private final ExpandedNodeId targetNodeId;
    private final Direction direction;
    public static final Predicate<Reference> HAS_COMPONENT_PREDICATE = reference -> reference.isForward() && Identifiers.HasComponent.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> HAS_PROPERTY_PREDICATE = reference -> reference.isForward() && Identifiers.HasProperty.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> HAS_TYPE_DEFINITION_PREDICATE = reference -> reference.isForward() && Identifiers.HasTypeDefinition.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> HAS_EVENT_SOURCE_PREDICATE = reference -> reference.isForward() && Identifiers.HasEventSource.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> HAS_NOTIFIER_PREDICATE = reference -> reference.isForward() && Identifiers.HasNotifier.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> ORGANIZES_PREDICATE = reference -> reference.isForward() && Identifiers.Organizes.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> HAS_DESCRIPTION_PREDICATE = reference -> reference.isForward() && Identifiers.HasDescription.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> HAS_MODELLING_RULE_PREDICATE = reference -> reference.isForward() && Identifiers.HasModellingRule.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> ALWAYS_GENERATES_EVENT_PREDICATE = reference -> reference.isForward() && Identifiers.AlwaysGeneratesEvent.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> HAS_SUBTYPE = reference -> reference.isForward() && Identifiers.HasSubtype.equals((Object)reference.getReferenceTypeId());
    public static final Predicate<Reference> SUBTYPE_OF = reference -> reference.isInverse() && Identifiers.HasSubtype.equals((Object)reference.getReferenceTypeId());

    @Deprecated
    public Reference(NodeId sourceNodeId, NodeId referenceTypeId, ExpandedNodeId targetNodeId, NodeClass targetNodeClass, boolean forward) {
        this(sourceNodeId, referenceTypeId, targetNodeId, targetNodeClass, forward ? Direction.FORWARD : Direction.INVERSE);
    }

    @Deprecated
    public Reference(NodeId sourceNodeId, NodeId referenceTypeId, ExpandedNodeId targetNodeId, NodeClass targetNodeClass, Direction direction) {
        this(sourceNodeId, referenceTypeId, targetNodeId, direction);
    }

    public Reference(NodeId sourceNodeId, NodeId referenceTypeId, ExpandedNodeId targetNodeId, boolean forward) {
        this(sourceNodeId, referenceTypeId, targetNodeId, forward ? Direction.FORWARD : Direction.INVERSE);
    }

    public Reference(NodeId sourceNodeId, NodeId referenceTypeId, ExpandedNodeId targetNodeId, Direction direction) {
        this.sourceNodeId = sourceNodeId;
        this.referenceTypeId = referenceTypeId;
        this.targetNodeId = targetNodeId;
        this.direction = direction;
    }

    public NodeId getSourceNodeId() {
        return this.sourceNodeId;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public ExpandedNodeId getTargetNodeId() {
        return this.targetNodeId;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isForward() {
        return this.direction == Direction.FORWARD;
    }

    public boolean isInverse() {
        return this.direction == Direction.INVERSE;
    }

    @Deprecated
    public Optional<Reference> invert() {
        return this.getTargetNodeId().local().map(sourceNodeId -> new Reference((NodeId)sourceNodeId, this.getReferenceTypeId(), this.getSourceNodeId().expanded(), !this.isForward()));
    }

    public Optional<Reference> invert(NamespaceTable namespaceTable) {
        return this.getTargetNodeId().local(namespaceTable).map(sourceNodeId -> new Reference((NodeId)sourceNodeId, this.getReferenceTypeId(), this.getSourceNodeId().expanded(), !this.isForward()));
    }

    public Reference reindex(NamespaceTable namespaceTable, String sourceNamespaceUri, String referenceNamespaceUri, String targetNamespaceUri) {
        NodeId newSourceNodeId = this.sourceNodeId.reindex(namespaceTable, sourceNamespaceUri);
        NodeId newReferenceTypeId = this.referenceTypeId.reindex(namespaceTable, referenceNamespaceUri);
        ExpandedNodeId newTargetNodeId = this.targetNodeId.local(namespaceTable).map(id -> id.reindex(namespaceTable, targetNamespaceUri).expanded()).orElse(this.targetNodeId);
        return new Reference(newSourceNodeId, newReferenceTypeId, newTargetNodeId, this.direction);
    }

    public boolean subtypeOf(NodeId superTypeId) {
        return this.subtypeOf(superTypeId, BuiltinReferenceType.getReferenceMap());
    }

    public boolean subtypeOf(NodeId superTypeId, Map<NodeId, ReferenceType> referenceTypes) {
        return this.subtypeOf(this.referenceTypeId, superTypeId, referenceTypes);
    }

    private boolean subtypeOf(NodeId typeId, NodeId superTypeId, Map<NodeId, ReferenceType> referenceTypes) {
        ReferenceType referenceType = referenceTypes.get(typeId);
        if (referenceType == null) {
            LoggerFactory.getLogger(this.getClass()).warn("Unknown reference type: {}", (Object)typeId);
            return false;
        }
        return referenceType.getSuperTypeId().map(id -> id.equals((Object)superTypeId) || this.subtypeOf((NodeId)id, superTypeId, referenceTypes)).orElse(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reference reference = (Reference)o;
        return Objects.equals(this.sourceNodeId, reference.sourceNodeId) && Objects.equals(this.referenceTypeId, reference.referenceTypeId) && Objects.equals(this.targetNodeId, reference.targetNodeId) && this.direction == reference.direction;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceNodeId, this.referenceTypeId, this.targetNodeId, this.direction});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sourceNodeId", (Object)this.sourceNodeId).add("referenceTypeId", (Object)this.referenceTypeId).add("targetNodeId", (Object)this.targetNodeId).add("direction", (Object)this.direction).toString();
    }

    public static enum Direction {
        FORWARD,
        INVERSE;

    }
}

