/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.factories;

import org.eclipse.milo.opcua.sdk.server.AbstractLifecycle;
import org.eclipse.milo.opcua.sdk.server.ObjectTypeManager;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.UaNodeManager;
import org.eclipse.milo.opcua.sdk.server.VariableTypeManager;
import org.eclipse.milo.opcua.sdk.server.api.NodeManager;
import org.eclipse.milo.opcua.sdk.server.model.nodes.objects.BaseEventNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.factories.NodeFactory;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class EventFactory
extends AbstractLifecycle {
    private final NodeManager<UaNode> nodeManager = new UaNodeManager();
    private final OpcUaServer server;
    private final NodeFactory nodeFactory;

    public EventFactory(OpcUaServer server) {
        this(server, server.getObjectTypeManager(), server.getVariableTypeManager());
    }

    public EventFactory(OpcUaServer server, ObjectTypeManager objectTypeManager, VariableTypeManager variableTypeManager) {
        this.server = server;
        this.nodeFactory = new NodeFactory(new EventNodeContext(server, this.nodeManager), objectTypeManager, variableTypeManager);
    }

    @Override
    protected void onStartup() {
        this.server.getAddressSpaceManager().register(this.nodeManager);
    }

    @Override
    protected void onShutdown() {
        this.server.getAddressSpaceManager().unregister(this.nodeManager);
    }

    public BaseEventNode createEvent(NodeId nodeId, NodeId typeDefinitionId) throws UaException {
        return (BaseEventNode)this.nodeFactory.createNode(nodeId, typeDefinitionId, true);
    }

    private static class EventNodeContext
    implements UaNodeContext {
        private final OpcUaServer server;
        private final NodeManager<UaNode> nodeManager;

        EventNodeContext(OpcUaServer server, NodeManager<UaNode> nodeManager) {
            this.server = server;
            this.nodeManager = nodeManager;
        }

        @Override
        public OpcUaServer getServer() {
            return this.server;
        }

        @Override
        public NodeManager<UaNode> getNodeManager() {
            return this.nodeManager;
        }
    }
}

