/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.events.conversions;

import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.BuiltinDataType;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;

final class ByteStringConversions {
    private ByteStringConversions() {
    }

    @Nullable
    static UUID byteStringToGuid(@Nonnull ByteString bs) {
        if (bs.length() != 16) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bs.bytesOrEmpty());
        Long high = byteBuffer.getLong();
        Long low = byteBuffer.getLong();
        return new UUID(high, low);
    }

    @Nonnull
    static String byteStringToString(@Nonnull ByteString bs) {
        return ByteBufUtil.hexDump((byte[])bs.bytesOrEmpty());
    }

    @Nullable
    static Object convert(@Nonnull Object o, BuiltinDataType targetType, boolean implicit) {
        if (o instanceof ByteString) {
            ByteString bs = (ByteString)o;
            return implicit ? ByteStringConversions.implicitConversion(bs, targetType) : ByteStringConversions.explicitConversion(bs, targetType);
        }
        return null;
    }

    @Nullable
    static Object explicitConversion(@Nonnull ByteString bs, BuiltinDataType targetType) {
        switch (targetType) {
            case Guid: {
                return ByteStringConversions.byteStringToGuid(bs);
            }
            case String: {
                return ByteStringConversions.byteStringToString(bs);
            }
        }
        return ByteStringConversions.implicitConversion(bs, targetType);
    }

    @Nullable
    static Object implicitConversion(@Nonnull ByteString bs, BuiltinDataType targetType) {
        return null;
    }
}

