/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server;

import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.SecurityConfiguration;
import org.eclipse.milo.opcua.sdk.server.services.DefaultAttributeHistoryServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.DefaultAttributeServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.DefaultMethodServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.DefaultMonitoredItemServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.DefaultNodeManagementServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.DefaultQueryServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.DefaultSubscriptionServiceSet;
import org.eclipse.milo.opcua.sdk.server.services.DefaultViewServiceSet;
import org.eclipse.milo.opcua.sdk.server.subscriptions.SubscriptionManager;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.CancelResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.server.services.NodeManagementServiceSet;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.server.services.SessionServiceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session
implements SessionServiceSet {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<LifecycleListener> listeners = Lists.newCopyOnWriteArrayList();
    private final SubscriptionManager subscriptionManager;
    private volatile long secureChannelId;
    private volatile Object identityObject;
    private volatile ByteString lastNonce = ByteString.NULL_VALUE;
    private volatile long lastActivity = System.nanoTime();
    private volatile ScheduledFuture<?> checkTimeoutFuture;
    private final DefaultAttributeServiceSet attributeServiceSet;
    private final DefaultAttributeHistoryServiceSet attributeHistoryServiceSet;
    private final DefaultMethodServiceSet methodServiceSet;
    private final DefaultMonitoredItemServiceSet monitoredItemServiceSet;
    private final DefaultNodeManagementServiceSet nodeManagementServiceSet;
    private final DefaultQueryServiceSet queryServiceSet;
    private final DefaultSubscriptionServiceSet subscriptionServiceSet;
    private final DefaultViewServiceSet viewServiceSet;
    private volatile EndpointDescription endpoint;
    private volatile SecurityConfiguration securityConfiguration;
    private volatile InetAddress clientAddress;
    private volatile String[] localeIds;
    private final OpcUaServer server;
    private final NodeId sessionId;
    private final String sessionName;
    private final Duration sessionTimeout;

    public Session(OpcUaServer server, NodeId sessionId, String sessionName, Duration sessionTimeout, long secureChannelId, EndpointDescription endpoint, SecurityConfiguration securityConfiguration) {
        this.server = server;
        this.sessionId = sessionId;
        this.sessionName = sessionName;
        this.sessionTimeout = sessionTimeout;
        this.secureChannelId = secureChannelId;
        this.securityConfiguration = securityConfiguration;
        this.endpoint = endpoint;
        this.subscriptionManager = new SubscriptionManager(this, server);
        this.attributeServiceSet = new DefaultAttributeServiceSet();
        this.attributeHistoryServiceSet = new DefaultAttributeHistoryServiceSet();
        this.methodServiceSet = new DefaultMethodServiceSet();
        this.monitoredItemServiceSet = new DefaultMonitoredItemServiceSet(this.subscriptionManager);
        this.nodeManagementServiceSet = new DefaultNodeManagementServiceSet();
        this.queryServiceSet = new DefaultQueryServiceSet();
        this.subscriptionServiceSet = new DefaultSubscriptionServiceSet(this.subscriptionManager);
        this.viewServiceSet = new DefaultViewServiceSet();
        this.checkTimeoutFuture = server.getScheduledExecutorService().schedule(this::checkTimeout, sessionTimeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OpcUaServer getServer() {
        return this.server;
    }

    public long getSecureChannelId() {
        return this.secureChannelId;
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public EndpointDescription getEndpoint() {
        return this.endpoint;
    }

    @Nullable
    public Object getIdentityObject() {
        return this.identityObject;
    }

    public void setSecureChannelId(long secureChannelId) {
        this.secureChannelId = secureChannelId;
    }

    public void setIdentityObject(Object identityObject) {
        this.identityObject = identityObject;
    }

    public void setEndpoint(EndpointDescription endpoint) {
        this.endpoint = endpoint;
    }

    public void setSecurityConfiguration(SecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public void setClientAddress(InetAddress clientAddress) {
        this.clientAddress = clientAddress;
    }

    public InetAddress getClientAddress() {
        return this.clientAddress;
    }

    void addLifecycleListener(LifecycleListener listener) {
        this.listeners.add(listener);
    }

    void updateLastActivity() {
        this.lastActivity = System.nanoTime();
    }

    void setLastNonce(ByteString lastNonce) {
        this.lastNonce = lastNonce;
    }

    public ByteString getLastNonce() {
        return this.lastNonce;
    }

    private void checkTimeout() {
        long elapsed = Math.abs(System.nanoTime() - this.lastActivity);
        if (elapsed > this.sessionTimeout.toNanos()) {
            this.logger.debug("Session id={} lifetime expired ({}ms).", (Object)this.sessionId, (Object)this.sessionTimeout.toMillis());
            this.subscriptionManager.sessionClosed(true);
            this.listeners.forEach(listener -> listener.onSessionClosed(this, true));
        } else {
            long remaining = this.sessionTimeout.toNanos() - elapsed;
            this.logger.trace("Session id={} timeout scheduled for +{}s.", (Object)this.sessionId, (Object)Duration.ofNanos(remaining).getSeconds());
            this.checkTimeoutFuture = this.server.getScheduledExecutorService().schedule(this::checkTimeout, remaining, TimeUnit.NANOSECONDS);
        }
    }

    public NodeId getSessionId() {
        return this.sessionId;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    @Nullable
    public String[] getLocaleIds() {
        return this.localeIds;
    }

    public void setLocaleIds(@Nullable String[] localeIds) {
        this.localeIds = localeIds;
    }

    public DefaultAttributeServiceSet getAttributeServiceSet() {
        return this.attributeServiceSet;
    }

    public DefaultAttributeHistoryServiceSet getAttributeHistoryServiceSet() {
        return this.attributeHistoryServiceSet;
    }

    public DefaultMethodServiceSet getMethodServiceSet() {
        return this.methodServiceSet;
    }

    public DefaultMonitoredItemServiceSet getMonitoredItemServiceSet() {
        return this.monitoredItemServiceSet;
    }

    public NodeManagementServiceSet getNodeManagementServiceSet() {
        return this.nodeManagementServiceSet;
    }

    public DefaultQueryServiceSet getQueryServiceSet() {
        return this.queryServiceSet;
    }

    public DefaultSubscriptionServiceSet getSubscriptionServiceSet() {
        return this.subscriptionServiceSet;
    }

    public DefaultViewServiceSet getViewServiceSet() {
        return this.viewServiceSet;
    }

    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public void onCreateSession(ServiceRequest serviceRequest) {
        serviceRequest.setServiceFault(0x80020000L);
    }

    public void onActivateSession(ServiceRequest serviceRequest) {
        serviceRequest.setServiceFault(0x80020000L);
    }

    public void onCloseSession(ServiceRequest serviceRequest) {
        CloseSessionRequest request = (CloseSessionRequest)serviceRequest.getRequest();
        this.close(request.getDeleteSubscriptions());
        serviceRequest.setResponse((UaResponseMessage)new CloseSessionResponse(serviceRequest.createResponseHeader()));
    }

    void close(boolean deleteSubscriptions) {
        if (this.checkTimeoutFuture != null) {
            this.checkTimeoutFuture.cancel(false);
        }
        this.subscriptionManager.sessionClosed(deleteSubscriptions);
        this.listeners.forEach(listener -> listener.onSessionClosed(this, deleteSubscriptions));
    }

    public void onCancel(ServiceRequest serviceRequest) throws UaException {
        serviceRequest.setResponse((UaResponseMessage)new CancelResponse(serviceRequest.createResponseHeader(), Unsigned.uint((int)0)));
    }

    public static interface LifecycleListener {
        public void onSessionClosed(Session var1, boolean var2);
    }
}

