/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;

public class FutureUtils {
    public static <T> CompletableFuture<List<T>> sequence(Stream<CompletableFuture<T>> stream) {
        return FutureUtils.sequence(stream.collect(Collectors.toList()));
    }

    public static <T> CompletableFuture<List<T>> sequence(List<CompletableFuture<T>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture[] fa = futures.toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(fa).thenApply(v -> {
            ArrayList results = new ArrayList(futures.size());
            for (CompletableFuture cf : futures) {
                results.add(cf.join());
            }
            return results;
        });
    }

    public static <T> CompletableFuture<List<T>> sequence(CompletableFuture<T> ... futures) {
        if (futures.length == 0) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.allOf(futures).thenApply(v -> {
            ArrayList results = new ArrayList(futures.length);
            for (CompletableFuture cf : futures) {
                results.add(cf.join());
            }
            return results;
        });
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable ex) {
        CompletableFuture f = new CompletableFuture();
        f.completeExceptionally(ex);
        return f;
    }

    public static <T> CompletableFuture<T> failedUaFuture(long statusCode) {
        return FutureUtils.failedUaFuture(new StatusCode(statusCode));
    }

    public static <T> CompletableFuture<T> failedUaFuture(StatusCode statusCode) {
        return FutureUtils.failedFuture(new UaException(statusCode));
    }

    public static <T> CompletableFuture<T> failedUaFuture(Throwable cause, long statusCode) {
        return FutureUtils.failedFuture(new UaException(statusCode, cause));
    }

    public static <T> CompletionBuilder<T> complete(CompletableFuture<T> future) {
        return new CompletionBuilder(future);
    }

    public static <T> CompletionBuilder<T> completeAsync(CompletableFuture<T> future, Executor executor) {
        return new AsyncCompletionBuilder<T>(future, executor);
    }

    private static final class AsyncCompletionBuilder<T>
    extends CompletionBuilder<T> {
        private final Executor executor;

        AsyncCompletionBuilder(CompletableFuture<T> toComplete, Executor executor) {
            super(toComplete);
            this.executor = executor;
        }

        @Override
        public CompletableFuture<T> with(CompletableFuture<T> future) {
            future.whenCompleteAsync((v, ex) -> {
                if (ex != null) {
                    this.toComplete.completeExceptionally((Throwable)ex);
                } else {
                    this.toComplete.complete(v);
                }
            }, this.executor);
            return this.toComplete;
        }
    }

    public static class CompletionBuilder<T> {
        final CompletableFuture<T> toComplete;

        private CompletionBuilder(CompletableFuture<T> toComplete) {
            this.toComplete = toComplete;
        }

        public CompletionBuilder<T> async(Executor executor) {
            return new AsyncCompletionBuilder<T>(this.toComplete, executor);
        }

        public CompletableFuture<T> with(CompletableFuture<T> future) {
            future.whenComplete((v, ex) -> {
                if (ex != null) {
                    this.toComplete.completeExceptionally((Throwable)ex);
                } else {
                    this.toComplete.complete(v);
                }
            });
            return this.toComplete;
        }
    }
}

