/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;

public class SemanticChangeStructureDataType
implements UaStructure {
    public static final NodeId TypeId = Identifiers.SemanticChangeStructureDataType;
    public static final NodeId BinaryEncodingId = Identifiers.SemanticChangeStructureDataType_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.SemanticChangeStructureDataType_Encoding_DefaultXml;
    protected final NodeId affected;
    protected final NodeId affectedType;

    public SemanticChangeStructureDataType() {
        this.affected = null;
        this.affectedType = null;
    }

    public SemanticChangeStructureDataType(NodeId affected, NodeId affectedType) {
        this.affected = affected;
        this.affectedType = affectedType;
    }

    public NodeId getAffected() {
        return this.affected;
    }

    public NodeId getAffectedType() {
        return this.affectedType;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Affected", (Object)this.affected).add("AffectedType", (Object)this.affectedType).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<SemanticChangeStructureDataType> {
        @Override
        public Class<SemanticChangeStructureDataType> getType() {
            return SemanticChangeStructureDataType.class;
        }

        @Override
        public SemanticChangeStructureDataType decode(UaDecoder decoder) throws UaSerializationException {
            NodeId affected = decoder.readNodeId("Affected");
            NodeId affectedType = decoder.readNodeId("AffectedType");
            return new SemanticChangeStructureDataType(affected, affectedType);
        }

        @Override
        public void encode(SemanticChangeStructureDataType value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeNodeId("Affected", value.affected);
            encoder.writeNodeId("AffectedType", value.affectedType);
        }
    }
}

