/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;

public class FindServersResponse
implements UaResponseMessage {
    public static final NodeId TypeId = Identifiers.FindServersResponse;
    public static final NodeId BinaryEncodingId = Identifiers.FindServersResponse_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.FindServersResponse_Encoding_DefaultXml;
    protected final ResponseHeader responseHeader;
    protected final ApplicationDescription[] servers;

    public FindServersResponse() {
        this.responseHeader = null;
        this.servers = null;
    }

    public FindServersResponse(ResponseHeader responseHeader, ApplicationDescription[] servers) {
        this.responseHeader = responseHeader;
        this.servers = servers;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Nullable
    public ApplicationDescription[] getServers() {
        return this.servers;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ResponseHeader", (Object)this.responseHeader).add("Servers", (Object)this.servers).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<FindServersResponse> {
        @Override
        public Class<FindServersResponse> getType() {
            return FindServersResponse.class;
        }

        @Override
        public FindServersResponse decode(UaDecoder decoder) throws UaSerializationException {
            ResponseHeader responseHeader = decoder.readBuiltinStruct("ResponseHeader", ResponseHeader.class);
            ApplicationDescription[] servers = (ApplicationDescription[])decoder.readBuiltinStructArray("Servers", ApplicationDescription.class);
            return new FindServersResponse(responseHeader, servers);
        }

        @Override
        public void encode(FindServersResponse value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeBuiltinStruct("ResponseHeader", value.responseHeader, ResponseHeader.class);
            encoder.writeBuiltinStructArray("Servers", value.servers, ApplicationDescription.class);
        }
    }
}

