/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import com.google.common.base.MoreObjects;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.BuiltinDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;

public class BrowseDescription
implements UaStructure {
    public static final NodeId TypeId = Identifiers.BrowseDescription;
    public static final NodeId BinaryEncodingId = Identifiers.BrowseDescription_Encoding_DefaultBinary;
    public static final NodeId XmlEncodingId = Identifiers.BrowseDescription_Encoding_DefaultXml;
    protected final NodeId nodeId;
    protected final BrowseDirection browseDirection;
    protected final NodeId referenceTypeId;
    protected final Boolean includeSubtypes;
    protected final UInteger nodeClassMask;
    protected final UInteger resultMask;

    public BrowseDescription() {
        this.nodeId = null;
        this.browseDirection = null;
        this.referenceTypeId = null;
        this.includeSubtypes = null;
        this.nodeClassMask = null;
        this.resultMask = null;
    }

    public BrowseDescription(NodeId nodeId, BrowseDirection browseDirection, NodeId referenceTypeId, Boolean includeSubtypes, UInteger nodeClassMask, UInteger resultMask) {
        this.nodeId = nodeId;
        this.browseDirection = browseDirection;
        this.referenceTypeId = referenceTypeId;
        this.includeSubtypes = includeSubtypes;
        this.nodeClassMask = nodeClassMask;
        this.resultMask = resultMask;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public BrowseDirection getBrowseDirection() {
        return this.browseDirection;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public Boolean getIncludeSubtypes() {
        return this.includeSubtypes;
    }

    public UInteger getNodeClassMask() {
        return this.nodeClassMask;
    }

    public UInteger getResultMask() {
        return this.resultMask;
    }

    @Override
    public NodeId getTypeId() {
        return TypeId;
    }

    @Override
    public NodeId getBinaryEncodingId() {
        return BinaryEncodingId;
    }

    @Override
    public NodeId getXmlEncodingId() {
        return XmlEncodingId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("NodeId", (Object)this.nodeId).add("BrowseDirection", (Object)this.browseDirection).add("ReferenceTypeId", (Object)this.referenceTypeId).add("IncludeSubtypes", (Object)this.includeSubtypes).add("NodeClassMask", (Object)this.nodeClassMask).add("ResultMask", (Object)this.resultMask).toString();
    }

    public static class Codec
    extends BuiltinDataTypeCodec<BrowseDescription> {
        @Override
        public Class<BrowseDescription> getType() {
            return BrowseDescription.class;
        }

        @Override
        public BrowseDescription decode(UaDecoder decoder) throws UaSerializationException {
            NodeId nodeId = decoder.readNodeId("NodeId");
            BrowseDirection browseDirection = BrowseDirection.from(decoder.readInt32("BrowseDirection"));
            NodeId referenceTypeId = decoder.readNodeId("ReferenceTypeId");
            Boolean includeSubtypes = decoder.readBoolean("IncludeSubtypes");
            UInteger nodeClassMask = decoder.readUInt32("NodeClassMask");
            UInteger resultMask = decoder.readUInt32("ResultMask");
            return new BrowseDescription(nodeId, browseDirection, referenceTypeId, includeSubtypes, nodeClassMask, resultMask);
        }

        @Override
        public void encode(BrowseDescription value, UaEncoder encoder) throws UaSerializationException {
            encoder.writeNodeId("NodeId", value.nodeId);
            encoder.writeInt32("BrowseDirection", value.browseDirection != null ? value.browseDirection.getValue() : 0);
            encoder.writeNodeId("ReferenceTypeId", value.referenceTypeId);
            encoder.writeBoolean("IncludeSubtypes", value.includeSubtypes);
            encoder.writeUInt32("NodeClassMask", value.nodeClassMask);
            encoder.writeUInt32("ResultMask", value.resultMask);
        }
    }
}

